/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.Tracepoint;

public class TracepointState
implements Tracepoint,
Comparable<TracepointState>,
RJIOExternalizable {
    public static final int FLAG_ENABLED = 1;
    public static final int FLAG_MB_ENTRY = 65536;
    public static final int FLAG_MB_EXIT = 131072;
    public static final int FLAG_EXPR_INVALID = 0x1000000;
    public static final int FLAG_EXPR_EVAL_FAILED = 0x2000000;
    public static final String EB_FILEPATH = "exception";
    private static final int[] NO_IDX = new int[0];
    private int type;
    private String filePath;
    private long id;
    private String elementId;
    private int[] index;
    protected String elementLabel;
    protected int flags;
    protected String expr;

    static final List<TracepointState> readList(RJIO io) throws IOException {
        int l = io.readInt();
        ArrayList<TracepointState> list = new ArrayList<TracepointState>(l);
        String filePath = null;
        String elementId = null;
        int i = 0;
        while (i < l) {
            TracepointState state = new TracepointState();
            list.add(state);
            state.type = io.readInt();
            state.id = io.readLong();
            state.filePath = io.readString();
            if (state.filePath != null) {
                filePath = state.filePath;
            } else {
                state.filePath = filePath;
            }
            if (state.type != 0x1000000) {
                state.elementId = io.readString();
                if (state.elementId != null) {
                    elementId = state.elementId;
                } else {
                    state.elementId = elementId;
                }
                state.index = io.readIntArray();
                state.elementLabel = io.readString();
                state.flags = io.readInt();
                state.expr = io.readString();
            }
            ++i;
        }
        return list;
    }

    static final void writeList(List<TracepointState> list, RJIO io) throws IOException {
        int l = list.size();
        io.writeInt(l);
        String filePath = null;
        String elementId = null;
        int i = 0;
        while (i < l) {
            TracepointState state = list.get(i);
            io.writeInt(state.type);
            io.writeLong(state.id);
            if (state.filePath.equals(filePath)) {
                io.writeString(null);
            } else {
                filePath = state.filePath;
                io.writeString(filePath);
            }
            if (state.type != 0x1000000) {
                if (state.elementId.equals(elementId)) {
                    io.writeString(null);
                } else {
                    elementId = state.elementId;
                    io.writeString(elementId);
                }
                io.writeIntArray(state.index, state.index.length);
                io.writeString(state.elementLabel);
                io.writeInt(state.flags);
                io.writeString(state.expr);
            }
            ++i;
        }
    }

    public TracepointState(int type, String filePath, long id, String elementId, int[] index, String elementLabel, int flags, String expr) {
        if (filePath == null || elementId == null || index == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.filePath = filePath;
        this.id = id;
        this.elementId = elementId;
        this.index = index;
        this.elementLabel = elementLabel;
        this.flags = flags;
        this.expr = expr;
    }

    public TracepointState(int type, String filePath, long id, String elementId, String elementLabel, int flags, String expr) {
        if (filePath == null || elementId == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.filePath = filePath;
        this.id = id;
        this.elementId = elementId;
        this.index = NO_IDX;
        this.elementLabel = elementLabel;
        this.flags = flags;
        this.expr = expr;
    }

    public TracepointState(int type, String filePath, long id) {
        if (type != 0x1000000) {
            throw new IllegalArgumentException("type= " + type);
        }
        this.type = type;
        this.filePath = filePath;
        this.id = id;
    }

    private TracepointState() {
    }

    public TracepointState(RJIO io) throws IOException {
        this.type = io.readInt();
        this.id = io.readLong();
        this.filePath = io.readString();
        if (this.type == 0x1000000) {
            return;
        }
        this.elementId = io.readString();
        this.index = io.readIntArray();
        this.elementLabel = io.readString();
        this.flags = io.readInt();
        this.expr = io.readString();
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.type);
        io.writeLong(this.id);
        io.writeString(this.filePath);
        if (this.type == 0x1000000) {
            return;
        }
        io.writeString(this.elementId);
        io.writeIntArray(this.index, this.index.length);
        io.writeString(this.elementLabel);
        io.writeInt(this.flags);
        io.writeString(this.expr);
    }

    public TracepointState clone() {
        return new TracepointState(this.type, this.filePath, this.id, this.elementId, this.index, this.elementLabel, this.flags, this.expr);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.elementId;
    }

    public int[] getIndex() {
        return this.index;
    }

    public boolean isEnabled() {
        return (this.flags & 1) != 0;
    }

    public String getElementLabel() {
        return this.elementLabel;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getExpr() {
        return this.expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(TracepointState other) {
        int diff = this.filePath.compareTo(other.filePath);
        if (diff != 0) {
            return diff;
        }
        if (this.elementId != null) {
            if (other.elementId == null) return 4096;
            diff = this.elementId.compareTo(other.elementId);
            if (diff != 0) {
                return diff;
            }
        } else if (other.elementId != null) {
            return -4096;
        }
        if (this.id >= other.id) return 1;
        return -1;
    }

    public int hashCode() {
        return (int)((long)this.filePath.hashCode() * this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TracepointState)) {
            return false;
        }
        TracepointState other = (TracepointState)obj;
        return this.id == other.id && this.filePath.equals(other.filePath);
    }
}

