/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.statet.yaml.core.model.YamlLabelAccess;
import org.eclipse.statet.yaml.ui.YamlUIResources;
import org.eclipse.swt.graphics.Image;

public class YamlLabelProvider
extends StyledCellLabelProvider
implements ElementLabelProvider,
ILabelProvider {
    private YamlUIResources yamlResources = YamlUIResources.INSTANCE;

    public void dispose() {
        super.dispose();
        this.yamlResources = null;
    }

    public Image getImage(Object element) {
        if (element instanceof LtkModelElement) {
            return this.getImage((LtkModelElement)element);
        }
        if (element instanceof YamlLabelAccess) {
            return this.getImage((YamlLabelAccess)element);
        }
        return null;
    }

    public Image getImage(LtkModelElement element) {
        int cfr_ignored_0 = element.getElementType() & 0xFFF;
        return null;
    }

    public Image getImage(YamlLabelAccess access) {
        if (access.getType() == 66) {
            return this.yamlResources.getImage("org.eclipse.statet.yaml/image/obj/Label");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof LtkModelElement) {
            return this.getText((LtkModelElement)element);
        }
        if (element instanceof YamlLabelAccess) {
            return this.getText((YamlLabelAccess)element);
        }
        return null;
    }

    public String getText(LtkModelElement element) {
        return element.getElementName().getDisplayName();
    }

    public String getText(YamlLabelAccess access) {
        return access.getDisplayName();
    }

    public StyledString getStyledText(LtkModelElement element) {
        return new StyledString(element.getElementName().getDisplayName());
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        if (cellElement instanceof LtkModelElement) {
            LtkModelElement element = (LtkModelElement)cellElement;
            cell.setImage(this.getImage(element));
            StyledString styledText = this.getStyledText(element);
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
            super.update(cell);
        } else {
            cell.setImage(null);
            cell.setText(cellElement.toString());
            cell.setStyleRanges(null);
            super.update(cell);
        }
    }
}

