/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.core.input.DocumentParserInput;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.r.ui.RIdentifierGroups;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.RLexer;
import org.eclipse.statet.r.ui.text.r.IRTextTokens;

public class RDefaultTextStyleScanner
extends DocumentParserInput
implements ITokenScanner,
ISettingsChangedHandler {
    private final RLexer lexer = this.createLexer();
    private RTerminal lexerToken;
    private final EnumMap<RTerminal, IToken> tokens;
    private final IToken defaultToken;
    private final Map<String, IToken> specialSymbols;
    private final TextStyleManager textStyles;
    private int currentOffset;
    private int currentLength;

    protected static void putAll(Map<String, IToken> map, String[] symbols, IToken token) {
        int i = 0;
        while (i < symbols.length) {
            map.put(symbols[i], token);
            ++i;
        }
    }

    protected static void putAll(Map<RTerminal, IToken> map, RTerminal[] types, IToken token) {
        int i = 0;
        while (i < types.length) {
            map.put(types[i], token);
            ++i;
        }
    }

    public RDefaultTextStyleScanner(TextStyleManager textStyles) {
        this.lexer.reset((TextParserInput)this);
        this.textStyles = textStyles;
        this.defaultToken = this.getToken("text_R_rDefault");
        this.tokens = new EnumMap(RTerminal.class);
        this.registerTokens(this.tokens);
        this.specialSymbols = new HashMap<String, IToken>();
        this.updateSymbols(this.specialSymbols);
    }

    protected RLexer createLexer() {
        return new RLexer(32787);
    }

    protected void checkTokenMap() {
        RTerminal[] all;
        RTerminal[] rTerminalArray = all = RTerminal.values();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            RTerminal t = rTerminalArray[n2];
            if (this.tokens.get(t) == null) {
                System.out.println("Style Missing for: " + t.name());
            }
            ++n2;
        }
    }

    protected final RLexer getLexer() {
        return this.lexer;
    }

    protected final TextStyleManager getTextStyles() {
        return this.textStyles;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset(document);
        this.init(offset, offset + length);
        this.lexer.reset((TextParserInput)this);
        this.currentOffset = offset;
        this.currentLength = 0;
    }

    protected void resetSpecialSymbols() {
        this.specialSymbols.clear();
        this.updateSymbols(this.specialSymbols);
    }

    public IToken nextToken() {
        this.currentOffset += this.currentLength;
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.next();
        }
        this.currentLength = this.lexer.getOffset() - this.currentOffset;
        if (this.currentLength != 0) {
            return this.defaultToken;
        }
        this.currentLength = this.lexer.getLength();
        return this.getTokenFromScannerToken();
    }

    protected IToken getTokenFromScannerToken() {
        if (this.lexerToken == RTerminal.SYMBOL) {
            IToken token;
            String text = this.lexer.getText();
            if (text != null && (token = this.specialSymbols.get(text)) != null) {
                this.lexerToken = null;
                return token;
            }
            this.lexerToken = null;
            return this.defaultToken;
        }
        IToken token = this.tokens.get(this.lexerToken);
        this.lexerToken = null;
        return token;
    }

    public int getTokenOffset() {
        return this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }

    protected IToken getToken(String key) {
        return this.textStyles.getToken(key);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (groupIds.contains("r.editor/identifiergroups")) {
            this.resetSpecialSymbols();
            options.put("affects.Presentation", Boolean.TRUE);
        }
    }

    protected void registerTokens(EnumMap<RTerminal, IToken> map) {
        map.put(RTerminal.EOF, Token.EOF);
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.FLOWCONTROL, this.getToken("text_R_rFlowcontrol"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.GROUPING, this.getToken("text_R_rGrouping"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.SEPARATOR, this.getToken("text_R_rSeparators"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.ASSIGN, this.getToken("text_R_rAssignment"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.ASSIGN_SUB_EQUAL, this.getToken("text_R_rAssignment.Equalsign"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.OP, this.getToken("text_R_rOtherOperators"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.OP_SUB_LOGICAL, this.getToken("text_R_rOtherOperators.Logical"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.OP_SUB_RELATIONAL, this.getToken("text_R_rOtherOperators.Relational"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.SUBACCESS, this.getToken("text_R_rIndexing"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.NSGET, this.getToken("text_R_rIndexing"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.SPECIALCONST, this.getToken("text_R_rSpecialConstants"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.LOGICALCONST, this.getToken("text_R_rLogicalConstants"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.SYMBOL, this.getToken("text_R_rDefault"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.NUM, this.getToken("text_R_rNumbers"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.NUM_SUB_INT, this.getToken("text_R_rNumbers.Integer"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.NUM_SUB_CPLX, this.getToken("text_R_rNumbers.Complex"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.UNDEFINED, this.getToken("text_R_rUndefined"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.STRING, this.getToken("text_R_rString"));
        map.put(RTerminal.SYMBOL_G, this.getToken("text_R_rString"));
        map.put(RTerminal.SPECIAL, this.getToken("text_R_rOtherOperators"));
        RDefaultTextStyleScanner.putAll(map, IRTextTokens.COMMENT, this.getToken("text_R_rComment"));
    }

    protected void updateSymbols(Map<String, IToken> map) {
        RIdentifierGroups groups = RUIPlugin.getInstance().getRIdentifierGroups();
        groups.getReadLock().lock();
        try {
            RDefaultTextStyleScanner.putAll(map, groups.getAssignmentIdentifiers(), this.getToken("text_R_rDefault.Assignment"));
            RDefaultTextStyleScanner.putAll(map, groups.getLogicalIdentifiers(), this.getToken("text_R_rDefault.Logical"));
            RDefaultTextStyleScanner.putAll(map, groups.getFlowcontrolIdentifiers(), this.getToken("text_R_rDefault.Flowcontrol"));
            RDefaultTextStyleScanner.putAll(map, groups.getCustom1Identifiers(), this.getToken("text_R_rDefault.Custom2"));
            RDefaultTextStyleScanner.putAll(map, groups.getCustom2Identifiers(), this.getToken("text_R_rDefault.Custom1"));
        }
        finally {
            groups.getReadLock().unlock();
        }
    }
}

