/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.builder;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextProjectNature;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectBuild;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectClean;

public class WikitextProjectBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.eclipse.statet.docmlet.resourceProjects.WikitextBuilder";
    private WikitextProjectNature wikitextProject;

    public WikitextProjectNature getWikitextProject() {
        return this.wikitextProject;
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.wikitextProject = WikitextProjectNature.getWikitextProject(this.getProject());
    }

    private void check(SubMonitor m) throws CoreException {
        if (this.wikitextProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", "Wikitext project nature is missing."));
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)21);
        try {
            this.check(m.newChild(5, 0));
            WikitextProjectBuild wikitextProjectBuild = new WikitextProjectBuild(this);
            wikitextProjectBuild.build(kind, m.newChild(20, 0));
            return null;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            throw e;
        }
        finally {
            m.done();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)21);
        try {
            try {
                this.check(m.newChild(1));
                WikitextProjectClean wikitextProjectBuild = new WikitextProjectClean(this);
                wikitextProjectBuild.clean(m.newChild(20));
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() == 8) {
                    throw new OperationCanceledException();
                }
                throw e;
            }
        }
        finally {
            m.done();
        }
    }
}

