/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.Scalar;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
abstract class YamlScalar
extends Scalar {
    YamlScalar(DslAstNode parent) {
        super(parent);
    }

    static class DQuoted
    extends YamlScalar {
        DQuoted(DslAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.doSetText(value);
        }

        public char getOperator() {
            return '\"';
        }
    }

    static class Folded
    extends YamlScalar {
        Folded(DslAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.doSetText(value);
        }

        public char getOperator() {
            return '>';
        }
    }

    static class Literal
    extends YamlScalar {
        Literal(DslAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.doSetText(value);
        }

        public char getOperator() {
            return '|';
        }
    }

    static class Plain
    extends YamlScalar {
        Plain(DslAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.doSetText(value);
        }

        Plain(DslAstNode parent, int offset) {
            super(parent);
            this.doSetStartEndOffset(offset);
        }

        public char getOperator() {
            return '\u0000';
        }
    }

    static class SQuoated
    extends YamlScalar {
        SQuoated(DslAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.doSetText(value);
        }

        public char getOperator() {
            return '\'';
        }
    }
}

