/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.util.List;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslParser;
import org.eclipse.statet.dsl.core.source.ast.Dummy;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.dsl.core.source.ast.Record;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class YamlDocument
extends Record {
    ImIdentityList<DslAstNode> directiveChildren = NO_CHILDREN;
    @Nullable DslAstNode directivesEndChild;
    ImIdentityList<DslAstNode> contentChildren = NO_CHILDREN;
    @Nullable DslAstNode endChild;

    YamlDocument(SourceComponent parent, int offset) {
        super(parent);
        this.doSetStartEndOffset(offset);
    }

    protected void finish(int endOffset, DslParser.NContainerBuilder containerBuilder) {
        int directiveEndIdx = 0;
        List children = containerBuilder.children;
        while (directiveEndIdx < children.size() && ((DslAstNode)children.get(directiveEndIdx)).getNodeType() == NodeType.DIRECTIVE) {
            ++directiveEndIdx;
        }
        int contentStartIdx = directiveEndIdx;
        if (this.directivesEndChild != null) {
            ++contentStartIdx;
        }
        int contentEndIdx = children.size();
        if (this.endChild != null) {
            --contentEndIdx;
        }
        if (contentStartIdx == contentEndIdx && this.directivesEndChild == null) {
            Dummy dummy = new Dummy(4334368, (DslAstNode)this, this.endChild != null ? this.endChild.getStartOffset() : this.getEndOffset());
            children.add(contentStartIdx, dummy);
            ++contentEndIdx;
        }
        super.finish(endOffset, containerBuilder);
        children = this.getChildren();
        this.directiveChildren = children.subList(0, directiveEndIdx);
        this.contentChildren = children.subList(contentStartIdx, contentEndIdx);
        if (contentEndIdx - contentStartIdx > 1) {
            DslAstNode child = (DslAstNode)children.get(contentStartIdx + 1);
            YamlDocument.setStatusThis((DslAstNode)child, (int)0x400200);
        }
    }

    public final ImIdentityList<DslAstNode> getDirectives() {
        return this.directiveChildren;
    }

    public final @Nullable DslAstNode getDirectivesEndMarker() {
        return this.directivesEndChild;
    }

    public final ImIdentityList<DslAstNode> getContentNodes() {
        return this.contentChildren;
    }

    public @Nullable DslAstNode getEndMarker() {
        return this.endChild;
    }
}

