/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.renv.core.RNumVersionConstraint;
import org.eclipse.statet.rj.renv.core.RPkgSpec;

@NonNullByDefault
public class BasicRPkgSpec
implements RPkgSpec {
    private final String name;
    private final RNumVersionConstraint version;

    public BasicRPkgSpec(String name, RNumVersionConstraint version) {
        this.name = (String)ObjectUtils.nonNullAssert((Object)name);
        this.version = (RNumVersionConstraint)ObjectUtils.nonNullAssert((Object)version);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RNumVersionConstraint getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.version.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        RPkgSpec other;
        return this == obj || obj instanceof RPkgSpec && this.name.equals((other = (RPkgSpec)obj).getName()) && this.version.equals(other.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name.length() + this.version.toString().length() + 12);
        sb.append(this.name);
        sb.append(" (version= ").append(this.version.toString());
        sb.append(')');
        return sb.toString();
    }
}

