/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;

@NonNullByDefault
public class SetDebugRequest
implements RJIOExternalizable {
    public static final int FRAME = 1;
    public static final int FUNCTION = 2;
    private static final int ENABLED = 0x1000000;
    private static final int TEMP = 256;
    private final long frameId;
    private final String fName;
    private final int properties;

    public SetDebugRequest(long frameId, boolean enable, boolean temp) {
        int props = 1;
        this.frameId = frameId;
        this.fName = null;
        if (enable) {
            props |= 0x1000000;
        }
        if (temp) {
            props |= 0x100;
        }
        this.properties = props;
    }

    public SetDebugRequest(int position, String fName, boolean enable, boolean temp) {
        int props = 2;
        this.frameId = position;
        this.fName = (String)ObjectUtils.nonNullAssert((Object)fName);
        if (enable) {
            props |= 0x1000000;
        }
        if (temp) {
            props |= 0x100;
        }
        this.properties = props;
    }

    public SetDebugRequest(RJIO io) throws IOException {
        this.properties = io.readInt();
        switch (this.properties & 0xF) {
            case 1: {
                this.frameId = io.readLong();
                this.fName = null;
                break;
            }
            case 2: {
                this.frameId = io.readInt();
                this.fName = io.readString();
                break;
            }
            default: {
                this.frameId = 0L;
                this.fName = null;
            }
        }
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeInt(this.properties);
        switch (this.properties & 0xF) {
            case 1: {
                io.writeLong(this.frameId);
                break;
            }
            case 2: {
                io.writeInt((int)this.frameId);
                io.writeString(this.fName);
                break;
            }
        }
    }

    public int getType() {
        return this.properties & 0xF;
    }

    public long getHandle() {
        return this.frameId;
    }

    public int getPosition() {
        return (int)this.frameId;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isTemp() {
        return (this.properties & 0x100) != 0;
    }

    public int getDebug() {
        return (this.properties & 0xFF000000) >>> 24;
    }
}

