/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RNullImpl;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;

@NonNullByDefault
public class RPromiseImpl
implements RObject,
ExternalizableRObject {
    public static final RPromiseImpl INSTANCE = new RPromiseImpl();
    private final @Nullable RObject expression;
    private final @Nullable RReferenceImpl environment;

    public RPromiseImpl() {
        this.expression = null;
        this.environment = null;
    }

    public RPromiseImpl(RObject expression, RReferenceImpl environment) {
        this.expression = expression;
        this.environment = environment;
    }

    public RPromiseImpl(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        if ((options & 0x20) == 0) {
            this.expression = factory.readObject(io);
            this.environment = new RReferenceImpl(io, factory);
        } else {
            this.expression = null;
            this.environment = null;
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        if ((io.flags & 4) == 0) {
            return;
        }
        int options = 0;
        if (this.expression == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if ((options & 0x20) == 0) {
            factory.writeObject(this.expression, io);
            this.environment.writeExternal(io, factory);
        }
    }

    @Override
    public byte getRObjectType() {
        return 18;
    }

    @Override
    public String getRClassName() {
        return "<promise>";
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public @Nullable RStore<?> getData() {
        return null;
    }

    @Override
    public @Nullable RList getAttributes() {
        return null;
    }

    public @Nullable RObject getExpression() {
        return this.expression;
    }

    public @Nullable RObject getEnvironment() {
        if (this.environment == null) {
            return null;
        }
        return this.environment.getReferencedRObjectType() == 8 ? this.environment : RNullImpl.INSTANCE;
    }
}

