/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.Asts;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.Block;
import org.eclipse.statet.r.core.source.ast.CallArg;
import org.eclipse.statet.r.core.source.ast.CallArgs;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.GenericVisitor;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;

@NonNullByDefault
public class RAsts
extends Asts {
    public static final @NonNull FCall.Arg[] NonNull_NO_ARGS = new FCall.Arg[0];
    public static final @Nullable FCall.Arg[] Nullable_NO_ARGS = new FCall.Arg[0];
    private static final int FAIL = -1;
    private static final int ELLIPSIS = -2;
    private static final int TEST_PARTIAL = -3;
    private static final int TEST_POSITION = -4;
    private static final int NA = -5;

    public static @Nullable RAstNode findLowestFDefAssignment(AstNode root, int offset) {
        LowestFDefAssignmentSearchVisitor visitor = new LowestFDefAssignmentSearchVisitor(offset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (InvocationTargetException | OperationCanceledException throwable) {
            // empty catch block
        }
        return visitor.assignment;
    }

    public static ImList<RAstNode> findDeepestCommands(AstNode root, int startOffset, int endOffset) {
        DeepestCommandsSearchVisitor visitor = new DeepestCommandsSearchVisitor(startOffset, endOffset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return ImCollections.toList(visitor.commands);
    }

    public static @Nullable RAstNode findNextCommands(AstNode root, int offset) {
        NextCommandsSearchVisitor visitor = new NextCommandsSearchVisitor(offset);
        try {
            root.accept((AstVisitor)visitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return visitor.next;
    }

    public static @Nullable RAstNode findSurroundingCommand(@Nullable AstNode node) {
        while (node != null) {
            if (node instanceof RAstNode) {
                RAstNode parent;
                RAstNode cand = (RAstNode)node;
                while ((parent = cand.getRParent()) != null) {
                    switch (parent.getNodeType()) {
                        case SOURCELINES: 
                        case BLOCK: {
                            return cand;
                        }
                    }
                    cand = parent;
                }
                node = cand.getParent();
                continue;
            }
            node = node.getParent();
        }
        return null;
    }

    public static @Nullable RAstNode findSurrounding(@Nullable AstNode node, NodeType nodeType) {
        while (node != null) {
            if (node instanceof RAstNode) {
                RAstNode cand = (RAstNode)node;
                while (true) {
                    if (cand.getNodeType() == nodeType) {
                        return cand;
                    }
                    if (cand.getNodeType() == NodeType.SOURCELINES) {
                        return null;
                    }
                    RAstNode parent = cand.getRParent();
                    if (parent == null) break;
                    cand = parent;
                }
                node = cand.getParent();
                continue;
            }
            node = node.getParent();
        }
        return null;
    }

    public static @Nullable AssignExpr checkAssign(RAstNode node) {
        switch (node.getNodeType()) {
            case A_RIGHT: 
            case A_EQUALS: 
            case A_LEFT: {
                Assignment assignNode = (Assignment)node;
                if (assignNode.isSearchOperator()) {
                    return new AssignExpr(node, AssignExpr.GLOBAL, assignNode.getTargetChild(), assignNode.getSourceChild());
                }
                return new AssignExpr(node, AssignExpr.LOCAL, assignNode.getTargetChild(), assignNode.getSourceChild());
            }
            case F_CALL: {
                String text;
                FCall callNode = (FCall)node;
                RAstNode refChild = callNode.getRefChild();
                if (refChild.getNodeType() != NodeType.SYMBOL || (text = refChild.getText()) == null || !text.equals("assign")) break;
                FCallArgMatch args = RAsts.matchArgs(callNode, RCoreFunctions.getDefinitions(null).BASE_Assign_fSpec);
                return new AssignExpr(node, AssignExpr.LOCAL, args.allocatedArgs[0], args.allocatedArgs[1]);
            }
            case F_CALL_ARGS: {
                return RAsts.checkAssign(node.getRParent());
            }
            case F_CALL_ARG: {
                return RAsts.checkAssign(node.getRParent().getRParent());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static FCallArgMatch matchArgs(final FCall.Args fCallArgs, RFunctionSpec fSpec, @Nullable RAstNode replValueArg, final ImList<? extends @Nullable RAstNode> inject0Args) {
        block57: {
            if (replValueArg != null && !inject0Args.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (inject0Args.isEmpty()) {
                fCallArgStartIdx = 0;
                fCallPlaceholderIdx = -1;
                getFCallArg = new IntFunction<FCall.Arg>(){

                    @Override
                    public FCall.Arg apply(int nodeIdx) {
                        return fCallArgs.getChild(nodeIdx);
                    }
                };
            } else {
                v0 = fCallPlaceholderIdx = inject0Args.size() == 1 ? RAsts.indexOfPlaceholder(fCallArgs) : -1;
                if (fCallPlaceholderIdx >= 0) {
                    fCallArgStartIdx = 0;
                    getFCallArg = new IntFunction<FCall.Arg>(){

                        @Override
                        public FCall.Arg apply(int nodeIdx) {
                            return nodeIdx == fCallPlaceholderIdx ? RAsts.createPlaceholderArg(fCallArgs.getChild(fCallPlaceholderIdx), (RAstNode)((Object)inject0Args.get(0))) : fCallArgs.getChild(nodeIdx);
                        }
                    };
                } else {
                    fCallArgStartIdx = inject0Args.size();
                    getFCallArg = new IntFunction<FCall.Arg>(){

                        @Override
                        public FCall.Arg apply(int nodeIdx) {
                            return nodeIdx < fCallArgStartIdx ? RAsts.createInjectArg(fCallArgs, (RAstNode)((Object)inject0Args.get(nodeIdx))) : fCallArgs.getChild(nodeIdx - fCallArgStartIdx);
                        }
                    };
                }
            }
            nodeArgCount = fCallArgStartIdx + fCallArgs.getChildCount();
            paramCount = fSpec.getParamCount();
            allocatedArgs = paramCount > 0 ? new FCall.Arg[paramCount] : RAsts.Nullable_NO_ARGS;
            ellipsisParamIdx = fSpec.indexOfParam("...");
            replValueParamIdx = replValueArg != null ? fSpec.indexOfParam("value") : -1;
            argsNode2paramIdx = new int[nodeArgCount];
            ellipsisCount = 0;
            failCount = 0;
            testPartial = false;
            if (replValueArg != null) {
                if (replValueParamIdx > 0) {
                    allocatedArgs[replValueParamIdx] = RAsts.createInjectArg(fCallArgs, replValueArg);
                    replValue2paramIdx = replValueParamIdx;
                } else if (replValueParamIdx == 0) {
                    replValue2paramIdx = -1;
                    ++failCount;
                } else {
                    replValue2paramIdx = -2;
                    ++ellipsisCount;
                }
            } else {
                replValue2paramIdx = -5;
            }
            nodeIdx = 0;
            while (nodeIdx < fCallArgStartIdx) {
                argsNode2paramIdx[nodeIdx] = -4;
                ++nodeIdx;
            }
            nodeIdx = fCallArgStartIdx;
            while (nodeIdx < nodeArgCount) {
                argNode = getFCallArg.apply(nodeIdx);
                if (argNode.hasName()) {
                    param = fSpec.getParam(argNode.getNameChild().getText());
                    if (param != null && param.index != ellipsisParamIdx) {
                        if (allocatedArgs[param.index] == null) {
                            allocatedArgs[param.index] = argNode;
                            argsNode2paramIdx[nodeIdx] = param.index;
                        } else {
                            ++failCount;
                            argsNode2paramIdx[nodeIdx] = -1;
                        }
                    } else {
                        testPartial = true;
                        argsNode2paramIdx[nodeIdx] = -3;
                    }
                } else {
                    argsNode2paramIdx[nodeIdx] = -4;
                }
                ++nodeIdx;
            }
            v1 = testStop = ellipsisParamIdx >= 0 ? ellipsisParamIdx : paramCount;
            if (!testPartial) break block57;
            partialArgs = null;
            nodeIdx = fCallArgStartIdx;
            while (nodeIdx < nodeArgCount) {
                block55: {
                    if (argsNode2paramIdx[nodeIdx] != -3) break block55;
                    argNode = getFCallArg.apply(nodeIdx);
                    matchIdx = -1;
                    name = argNode.getNameChild().getText();
                    if (name != null) {
                        paramIdx = 0;
                        while (paramIdx < testStop) {
                            if (allocatedArgs[paramIdx] == null && (paramName = fSpec.getParam(paramIdx).getName()) != null && paramName.startsWith(name)) {
                                if (matchIdx >= 0) {
                                    ++failCount;
                                    argsNode2paramIdx[nodeIdx] = -1;
                                    break block55;
                                }
                                matchIdx = paramIdx;
                            }
                            ++paramIdx;
                        }
                    }
                    if (matchIdx < 0) ** GOTO lbl-1000
                    if (partialArgs == null) {
                        partialArgs = new FCall.Arg[testStop];
                        partialArgs[matchIdx] = argNode;
                        argsNode2paramIdx[nodeIdx] = matchIdx;
                    } else if (partialArgs[matchIdx] == null) {
                        partialArgs[matchIdx] = argNode;
                        argsNode2paramIdx[nodeIdx] = matchIdx;
                    } else lbl-1000:
                    // 2 sources

                    {
                        ++ellipsisCount;
                        argsNode2paramIdx[nodeIdx] = -2;
                    }
                }
                ++nodeIdx;
            }
            if (partialArgs != null) {
                i = 0;
                while (i < testStop) {
                    if (partialArgs[i] != null) {
                        allocatedArgs[i] = partialArgs[i];
                    }
                    ++i;
                }
            }
        }
        if (replValueArg != null && replValueParamIdx != 0 && allocatedArgs[0] == null && nodeArgCount > 0) {
            switch (argsNode2paramIdx[0]) {
                case -1: {
                    break;
                }
                case -2: {
                    --ellipsisCount;
                }
                case -4: {
                    allocatedArgs[0] = getFCallArg.apply(0);
                    argsNode2paramIdx[0] = 0;
                    break;
                }
                default: {
                    allocatedArgs[0] = allocatedArgs[argsNode2paramIdx[0]];
                    allocatedArgs[argsNode2paramIdx[0]] = null;
                    argsNode2paramIdx[0] = 0;
                }
            }
        }
        paramIdx = 0;
        nodeIdx = 0;
        while (nodeIdx < nodeArgCount) {
            block56: {
                if (argsNode2paramIdx[nodeIdx] == -4) {
                    while (paramIdx < testStop) {
                        if (allocatedArgs[paramIdx] == null) {
                            argsNode2paramIdx[nodeIdx] = paramIdx;
                            allocatedArgs[paramIdx++] = getFCallArg.apply(nodeIdx);
                            break block56;
                        }
                        ++paramIdx;
                    }
                    argsNode2paramIdx[nodeIdx] = -2;
                    ++ellipsisCount;
                }
            }
            ++nodeIdx;
        }
        if (ellipsisParamIdx == -1 && ellipsisCount > 0) {
            nodeIdx = 0;
            while (nodeIdx < nodeArgCount) {
                if (argsNode2paramIdx[nodeIdx] == -2) {
                    argsNode2paramIdx[nodeIdx] = -1;
                }
                ++nodeIdx;
            }
            if (replValue2paramIdx == -2) {
                replValue2paramIdx = -1;
            }
            failCount += ellipsisCount;
            ellipsisCount = 0;
        }
        ellipsisArgs = ellipsisCount > 0 ? new FCall.Arg[ellipsisCount] : RAsts.NonNull_NO_ARGS;
        v2 = otherArgs = failCount > 0 ? new FCall.Arg[failCount] : RAsts.NonNull_NO_ARGS;
        if (ellipsisCount > 0 || failCount > 0) {
            ellipsisIdx = 0;
            otherIdx = 0;
            nodeIdx = 0;
            while (nodeIdx < nodeArgCount) {
                switch (argsNode2paramIdx[nodeIdx]) {
                    case -2: {
                        ellipsisArgs[ellipsisIdx++] = getFCallArg.apply(nodeIdx);
                        argsNode2paramIdx[nodeIdx] = ellipsisParamIdx;
                        break;
                    }
                    case -1: {
                        otherArgs[otherIdx++] = getFCallArg.apply(nodeIdx);
                    }
                }
                ++nodeIdx;
            }
            switch (replValue2paramIdx) {
                case -2: {
                    ellipsisArgs[ellipsisIdx++] = RAsts.createInjectArg(fCallArgs, replValueArg);
                    break;
                }
                case -1: {
                    otherArgs[otherIdx++] = RAsts.createInjectArg(fCallArgs, replValueArg);
                    break;
                }
            }
        }
        return new FCallArgMatch(fSpec, fCallArgs, fCallArgStartIdx, allocatedArgs, ellipsisArgs, otherArgs, argsNode2paramIdx);
    }

    private static FCall.Arg createInjectArg(FCall.Args argsNode, @Nullable RAstNode valueNode) {
        FCall.Arg arg = new FCall.Arg(argsNode, valueNode != null ? valueNode.getStartOffset() : Integer.MIN_VALUE, Integer.MIN_VALUE);
        arg.valueExpr.node = valueNode;
        arg.updateOffsets();
        return arg;
    }

    private static FCall.Arg createPlaceholderArg(FCall.Arg argNode, @Nullable RAstNode valueNode) {
        FCall.Arg arg = new FCall.Arg(argNode.getRParent(), argNode.getStartOffset(), argNode.getEndOffset());
        arg.argName = argNode.argName;
        arg.valueExpr.node = valueNode;
        return arg;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static FCallArgMatch matchArgs(FCall fCallNode, RFunctionSpec fSpec) {
        @Nullable RAstNode replValueArg = null;
        @Nullable ImList inject0Args = ImCollections.emptyList();
        RAstNode parentNode = fCallNode.getRParent();
        if (parentNode != null) {
            switch (parentNode.getNodeType()) {
                case PIPE_FORWARD: {
                    Pipe pipeNode = (Pipe)parentNode;
                    if (pipeNode.getTargetChild() != fCallNode) break;
                    inject0Args = ImCollections.newList((Object)((Object)pipeNode.getSourceChild()));
                    break;
                }
                case A_RIGHT: 
                case A_EQUALS: 
                case A_LEFT: {
                    Assignment assignNode = (Assignment)parentNode;
                    if (assignNode.getTargetChild() != fCallNode) break;
                    replValueArg = assignNode.getSourceChild();
                    break;
                }
            }
        }
        return RAsts.matchArgs(fCallNode.getArgsChild(), fSpec, replValueArg, (ImList<? extends RAstNode>)inject0Args);
    }

    public static @Nullable TextRegion getElementNameRegion(RAstNode node) {
        switch (node.getNodeType()) {
            case SYMBOL: 
            case STRING_CONST: {
                return node.getTextRegion();
            }
        }
        return null;
    }

    static int indexOfPlaceholder(CallArgs args) {
        ImList<? extends CallArg> argChildren = args.getArgChildren();
        int idx = 0;
        while (idx < argChildren.size()) {
            CallArg arg = (CallArg)((Object)argChildren.get(idx));
            RAstNode argValue = arg.getValueChild();
            if (argValue != null && argValue.getNodeType() == NodeType.PLACEHOLDER && argValue.getOperator(0) == RTerminal.PIPE_PLACEHOLDER) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static int @Nullable [] computeRExpressionIndex(RAstNode node, RAstNode baseNode) {
        IntArrayList topdown = new IntArrayList();
        while (node != baseNode) {
            RAstNode parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)node.getRParent())));
            switch (parent.getNodeType()) {
                case SOURCELINES: {
                    topdown.add(1 + parent.getChildIndex(node));
                    node = parent;
                    break;
                }
                case BLOCK: 
                case GROUP: 
                case NS_GET: 
                case NS_GET_INT: 
                case SUB_NAMED_PART: 
                case SUB_NAMED_SLOT: 
                case POWER: 
                case SIGN: 
                case SEQ: 
                case SPECIAL: 
                case MULT: 
                case ADD: 
                case RELATIONAL: 
                case NOT: 
                case AND: 
                case OR: 
                case MODEL: 
                case A_EQUALS: 
                case A_LEFT: 
                case A_COLON: 
                case HELP: {
                    topdown.add(2 + parent.getChildIndex(node));
                    node = parent;
                    break;
                }
                case A_RIGHT: {
                    topdown.add(3 - parent.getChildIndex(node));
                    node = parent;
                    break;
                }
                case C_IF: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: {
                    topdown.add(2 + parent.getChildIndex(node));
                    node = parent;
                    break;
                }
                case F_DEF: {
                    topdown.add(2 + parent.getChildIndex(node));
                    node = parent;
                    break;
                }
                case F_DEF_ARGS: {
                    node = parent;
                    break;
                }
                case F_DEF_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (FDef.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((FDef.Arg)arg).getRParent())));
                    if (node == ((FDef.Arg)arg).getDefaultChild()) {
                        topdown.add(1 + parent.getChildIndex(arg));
                    }
                    node = parent;
                    break;
                }
                case F_CALL: {
                    if (node == parent.getChild(0)) {
                        topdown.add(1);
                    }
                    node = parent;
                    break;
                }
                case F_CALL_ARGS: {
                    node = parent;
                    break;
                }
                case F_CALL_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (FCall.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((FCall.Arg)arg).getRParent())));
                    if (node == ((CallArg)arg).getValueChild()) {
                        topdown.add(2 + parent.getChildIndex(arg));
                    }
                    node = parent;
                    break;
                }
                case PIPE_FORWARD: {
                    CallArgs callArgs;
                    RAstNode subRef;
                    Pipe pipe = (Pipe)parent;
                    RAstNode target = pipe.getTargetChild();
                    int callShift = 0;
                    switch (target.getNodeType()) {
                        case F_CALL: {
                            subRef = null;
                            callArgs = ((FCall)target).getArgsChild();
                            callShift = 2;
                            break;
                        }
                        case SUB_INDEXED_S: 
                        case SUB_INDEXED_D: {
                            subRef = ((SubIndexed)target).getRefChild();
                            callArgs = ((SubIndexed)target).getArgsChild();
                            callShift = 3;
                            break;
                        }
                        case SUB_NAMED_PART: 
                        case SUB_NAMED_SLOT: {
                            subRef = ((SubNamed)target).getRefChild();
                            callArgs = null;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    if (subRef != null && subRef.getNodeType() == NodeType.PLACEHOLDER && subRef.getOperator(0) == RTerminal.PIPE_PLACEHOLDER) {
                        if (node == pipe.getSourceChild()) {
                            topdown.add(2);
                        }
                        node = parent;
                        break;
                    }
                    if (callArgs != null) {
                        int index;
                        int i;
                        int indexPlaceholder = RAsts.indexOfPlaceholder(callArgs);
                        if (node == pipe.getSourceChild()) {
                            topdown.add(indexPlaceholder >= 0 ? callShift + indexPlaceholder : callShift);
                        } else if (indexPlaceholder == -1 && (i = topdown.size() - 1) >= 0 && (index = topdown.getAt(i)) > 1) {
                            topdown.setAt(i, index + 1);
                        }
                        node = parent;
                        break;
                    }
                    return null;
                }
                case SUB_INDEXED_S: 
                case SUB_INDEXED_D: {
                    if (node == parent.getChild(0)) {
                        topdown.add(2);
                    }
                    node = parent;
                    break;
                }
                case SUB_INDEXED_ARGS: {
                    node = parent;
                    break;
                }
                case SUB_INDEXED_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (SubIndexed.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((SubIndexed.Arg)arg).getRParent())));
                    if (node == ((CallArg)arg).getValueChild()) {
                        topdown.add(3 + parent.getChildIndex(arg));
                    }
                    node = parent;
                    break;
                }
                case ERROR: 
                case DUMMY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent: type= " + String.valueOf((Object)node.getNodeType()));
                }
            }
        }
        int l = topdown.size();
        int[] path = new int[l];
        int i = 0;
        while (i < l) {
            path[i++] = topdown.getAt(l - i);
        }
        return path;
    }

    public static @Nullable List<RAstNode> computeRExpressionNodes(RAstNode node, RAstNode baseNode) {
        ArrayList<RAstNode> nodes = new ArrayList<RAstNode>();
        while (node != baseNode) {
            RAstNode parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)node.getRParent())));
            switch (parent.getNodeType()) {
                case SOURCELINES: 
                case BLOCK: 
                case GROUP: 
                case NS_GET: 
                case NS_GET_INT: 
                case SUB_NAMED_PART: 
                case SUB_NAMED_SLOT: 
                case POWER: 
                case SIGN: 
                case SEQ: 
                case SPECIAL: 
                case MULT: 
                case ADD: 
                case RELATIONAL: 
                case NOT: 
                case AND: 
                case OR: 
                case MODEL: 
                case A_RIGHT: 
                case A_EQUALS: 
                case A_LEFT: 
                case A_COLON: 
                case C_IF: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: 
                case HELP: {
                    nodes.add(node);
                    node = parent;
                    break;
                }
                case F_DEF: {
                    nodes.add(node);
                    node = parent;
                    break;
                }
                case F_DEF_ARGS: {
                    node = parent;
                    break;
                }
                case F_DEF_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (FDef.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((FDef.Arg)arg).getRParent())));
                    if (node == ((FDef.Arg)arg).getDefaultChild()) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case F_CALL: {
                    if (node == parent.getChild(0)) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case F_CALL_ARGS: {
                    node = parent;
                    break;
                }
                case F_CALL_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (FCall.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((FCall.Arg)arg).getRParent())));
                    if (node == ((CallArg)arg).getValueChild()) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case PIPE_FORWARD: {
                    Pipe pipe = (Pipe)parent;
                    if (node == pipe.getSourceChild()) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case SUB_INDEXED_S: 
                case SUB_INDEXED_D: {
                    if (node == parent.getChild(0)) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case SUB_INDEXED_ARGS: {
                    node = parent;
                    break;
                }
                case SUB_INDEXED_ARG: {
                    if (parent == baseNode) {
                        return null;
                    }
                    RAstNode arg = (SubIndexed.Arg)parent;
                    parent = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)((SubIndexed.Arg)arg).getRParent())));
                    if (node == ((CallArg)arg).getValueChild()) {
                        nodes.add(node);
                    }
                    node = parent;
                    break;
                }
                case ERROR: 
                case DUMMY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent: type= " + String.valueOf((Object)node.getNodeType()));
                }
            }
        }
        if (nodes.size() > 1) {
            Collections.reverse(nodes);
        }
        return nodes;
    }

    /*
     * Unable to fully structure code
     */
    public static RAstNode getRRootNode(RAstNode node, @Nullable IRegion region) {
        if (region != null) ** GOTO lbl10
        return node.getRRoot();
lbl-1000:
        // 1 sources

        {
            parent = node.getRParent();
            beginDiff = region.getOffset() - parent.getStartOffset();
            if (beginDiff > 0 || (endDiff = region.getOffset() + region.getLength() - parent.getEndOffset()) < 0) {
                return node;
            }
            if (beginDiff == 0 && endDiff == 0) {
                return parent.getNodeType() == NodeType.SOURCELINES ? node : parent;
            }
            node = parent;
lbl10:
            // 2 sources

            ** while (node.getRParent() != null)
        }
lbl11:
        // 1 sources

        return node;
    }

    public static boolean isParentChild(RAstNode parent, RAstNode child) {
        while ((child = child.getRParent()) != null) {
            if (child != parent) continue;
            return true;
        }
        return false;
    }

    public static boolean isSequenceNode(RAstNode node) {
        return switch (node.getNodeType()) {
            case NodeType.SOURCELINES, NodeType.BLOCK -> true;
            default -> false;
        };
    }

    public static @Nullable RAstNode getSequenceChild(RAstNode node) {
        RAstNode parent;
        while ((parent = node.getRParent()) != null) {
            switch (parent.getNodeType()) {
                case SOURCELINES: 
                case BLOCK: {
                    return node;
                }
            }
            node = parent;
        }
        return null;
    }

    public static RAstNode getSequenceChildElseRoot(RAstNode node) {
        RAstNode parent;
        while ((parent = node.getRParent()) != null) {
            switch (parent.getNodeType()) {
                case SOURCELINES: 
                case BLOCK: {
                    return node;
                }
            }
            node = parent;
        }
        return node;
    }

    public static @Nullable Object toJava(@Nullable RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            return RAsts.parseNum(node.getText());
                        }
                        case NUM_INT: {
                            return RAsts.parseInt(node.getText());
                        }
                        case TRUE: {
                            return Boolean.TRUE;
                        }
                        case FALSE: {
                            return Boolean.FALSE;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static @Nullable Boolean toJavaBoolean(@Nullable RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAsts.parseNum(node.getText());
                            if (num == null || num != Math.rint(num)) break;
                            return num.intValue() != 0;
                        }
                        case NUM_INT: {
                            Integer num = RAsts.parseInt(node.getText());
                            if (num == null) break;
                            return num != 0;
                        }
                        case TRUE: {
                            return Boolean.TRUE;
                        }
                        case FALSE: {
                            return Boolean.FALSE;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean toJavaBooleanValue(@Nullable RAstNode node, boolean defaultValue) {
        Boolean value = RAsts.toJavaBoolean(node);
        return value != null ? value : defaultValue;
    }

    public static @Nullable Integer toJavaInt(@Nullable RAstNode node, boolean coerceNonNumeric) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAsts.parseNum(node.getText());
                            if (num == null || num != Math.rint(num)) break;
                            return num.intValue();
                        }
                        case NUM_INT: {
                            return RAsts.parseInt(node.getText());
                        }
                        case TRUE: {
                            return coerceNonNumeric ? Integer.valueOf(1) : null;
                        }
                        case FALSE: {
                            return coerceNonNumeric ? Integer.valueOf(0) : null;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static @Nullable Integer toJavaInt(@Nullable RAstNode node) {
        return RAsts.toJavaInt(node, true);
    }

    public static @Nullable Float toJavaFloat(@Nullable RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAsts.parseNum(node.getText());
                            if (num == null || !(Math.abs(num) <= 3.4028234663852886E38)) break;
                            return Float.valueOf(num.floatValue());
                        }
                        case NUM_INT: {
                            Integer num = RAsts.parseInt(node.getText());
                            if (num == null) break;
                            return Float.valueOf(num.floatValue());
                        }
                        case TRUE: {
                            return Float.valueOf(1.0f);
                        }
                        case FALSE: {
                            return Float.valueOf(0.0f);
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    public static @Nullable Double toJavaDouble(@Nullable RAstNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case NUM_CONST: {
                    switch (node.getOperator(0)) {
                        case NUM_NUM: {
                            Double num = RAsts.parseNum(node.getText());
                            if (num == null) break;
                            return num;
                        }
                        case NUM_INT: {
                            Integer num = RAsts.parseInt(node.getText());
                            if (num == null) break;
                            return num.doubleValue();
                        }
                        case TRUE: {
                            return 1.0;
                        }
                        case FALSE: {
                            return 0.0;
                        }
                    }
                    return null;
                }
                case F_CALL_ARG: {
                    node = ((FCall.Arg)node).getValueChild();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static @Nullable Double parseNum(String text) {
        if (text != null && !text.isEmpty()) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static @Nullable Integer parseInt(String text) {
        if (text != null && !text.isEmpty()) {
            try {
                if (text.endsWith("L")) {
                    text = text.substring(0, text.length() - 1);
                }
                if (text.startsWith("0x")) {
                    text = text.substring(2);
                    return Integer.valueOf(text, 16);
                }
                return Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class AssignExpr {
        public static final Object GLOBAL = new Object();
        public static final Object LOCAL = new Object();
        public final Object environment;
        public final RAstNode assignNode;
        public final RAstNode targetNode;
        public final RAstNode valueNode;

        public AssignExpr(RAstNode assign, Object env, RAstNode target, RAstNode source) {
            this.assignNode = assign;
            this.environment = env;
            this.targetNode = target;
            this.valueNode = source;
        }
    }

    private static class DeepestCommandsSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int startOffset;
        private final int stopOffset;
        private @Nullable RAstNode container;
        private final List<RAstNode> commands = new ArrayList<RAstNode>();

        public DeepestCommandsSearchVisitor(int startOffset, int stopOffset) {
            this.startOffset = startOffset;
            this.stopOffset = stopOffset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getEndOffset() >= this.startOffset && (this.startOffset == this.stopOffset ? this.stopOffset >= node.getStartOffset() : this.stopOffset > node.getStartOffset()) && this.container != null && this.container == node.rParent) {
                this.commands.add(node);
            }
            if (node.getStartOffset() <= this.startOffset && this.stopOffset <= node.getEndOffset()) {
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            if (node.getStartOffset() <= this.startOffset && this.stopOffset <= node.getEndOffset()) {
                this.commands.clear();
                if (node.getStartOffset() == this.startOffset && this.stopOffset == node.getEndOffset()) {
                    this.commands.add(node);
                    this.container = null;
                    return;
                }
                this.container = node;
                node.acceptInRChildren(this);
                if (this.commands.isEmpty() && node.getEndOffset() > this.startOffset) {
                    this.commands.add(node);
                }
                return;
            }
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                this.commands.clear();
                this.container = node;
                node.acceptInRChildren(this);
                return;
            }
        }
    }

    public static final class FCallArgMatch {
        private final RFunctionSpec fSpec;
        private final FCall.Args fCallArgsNode;
        private final int fCallArgStartIdx;
        public final @Nullable FCall.Arg[] allocatedArgs;
        public final FCall.Arg[] ellipsisArgs;
        public final FCall.Arg[] otherArgs;
        private final int[] argsNode2paramIndex;

        private FCallArgMatch(RFunctionSpec fSpec, FCall.Args fCallArgsNode, int fCallArgStartIdx, @Nullable FCall.Arg[] allocatedArgs, FCall.Arg[] ellipsisArgs, FCall.Arg[] otherArgs, int[] argsNode2paramIdx) {
            this.fSpec = fSpec;
            this.fCallArgsNode = fCallArgsNode;
            this.fCallArgStartIdx = fCallArgStartIdx;
            this.allocatedArgs = allocatedArgs;
            this.ellipsisArgs = ellipsisArgs;
            this.otherArgs = otherArgs;
            this.argsNode2paramIndex = argsNode2paramIdx;
        }

        public RFunctionSpec getFunctionSpec() {
            return this.fSpec;
        }

        public FCall.Args getFCallArgsNode() {
            return this.fCallArgsNode;
        }

        public @Nullable FCall.Arg getArgNode(int paramIdx) {
            if (paramIdx >= 0) {
                return this.allocatedArgs[paramIdx];
            }
            return null;
        }

        public @Nullable FCall.Arg getArgNode(String name) {
            return this.getArgNode(this.fSpec.indexOfParam(name));
        }

        public @Nullable RAstNode getArgValueNode(int paramIdx) {
            if (paramIdx >= 0 && this.allocatedArgs[paramIdx] != null) {
                return this.allocatedArgs[paramIdx].getValueChild();
            }
            return null;
        }

        public @Nullable RAstNode getArgValueNode(String name) {
            return this.getArgValueNode(this.fSpec.indexOfParam(name));
        }

        public @Nullable RFunctionSpec.Parameter getParamForFCall(int fCallArgIdx) {
            if (fCallArgIdx >= 0) {
                fCallArgIdx += this.fCallArgStartIdx;
                if (this.fSpec.getParamCount() > this.fCallArgStartIdx) {
                    if (fCallArgIdx < this.argsNode2paramIndex.length) {
                        if (this.argsNode2paramIndex[fCallArgIdx] >= 0) {
                            return this.fSpec.getParam(this.argsNode2paramIndex[fCallArgIdx]);
                        }
                    } else if (fCallArgIdx == this.fCallArgStartIdx && this.argsNode2paramIndex.length == this.fCallArgStartIdx) {
                        return this.fSpec.getParam(this.fCallArgStartIdx);
                    }
                }
            }
            return null;
        }

        public @Nullable RFunctionSpec.Parameter getParamForInject(int injectArgIdx) {
            if (injectArgIdx >= 0 && injectArgIdx < this.fCallArgStartIdx && this.fSpec.getParamCount() > 0 && this.argsNode2paramIndex[injectArgIdx] >= 0) {
                return this.fSpec.getParam(this.argsNode2paramIndex[injectArgIdx]);
            }
            return null;
        }

        int[] argsNode2paramIdx() {
            return (int[])this.argsNode2paramIndex.clone();
        }

        public String toString() {
            return Arrays.toString(this.argsNode2paramIndex);
        }
    }

    private static class LowestFDefAssignmentSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int startOffset;
        private final int stopOffset;
        private boolean inAssignment;
        private @Nullable RAstNode assignment;

        public LowestFDefAssignmentSearchVisitor(int offset) {
            this.startOffset = offset;
            this.stopOffset = offset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Assignment node) throws InvocationTargetException {
            if (this.inAssignment) {
                node.getSourceChild().acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                this.inAssignment = true;
                node.getSourceChild().acceptInR(this);
                this.inAssignment = false;
                return;
            }
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
            if (this.inAssignment || node.getEndOffset() >= this.startOffset && this.stopOffset >= node.getStartOffset()) {
                RAstNode take = node;
                RAstNode candidate = node.getRParent();
                AssignExpr assign = null;
                while (candidate != null && (assign = RAsts.checkAssign(candidate)) != null && assign.valueNode == take) {
                    take = assign.assignNode;
                    candidate = take.getRParent();
                }
                this.assignment = take;
                throw new OperationCanceledException();
            }
        }
    }

    private static class NextCommandsSearchVisitor
    extends GenericVisitor
    implements AstVisitor {
        private final int offset;
        private @Nullable RAstNode container;
        private @Nullable RAstNode next;

        public NextCommandsSearchVisitor(int offset) {
            this.offset = offset;
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node instanceof RAstNode) {
                ((RAstNode)node).acceptInR(this);
                return;
            }
            if (node.getEndOffset() >= this.offset && this.offset >= node.getStartOffset()) {
                node.acceptInChildren((AstVisitor)this);
                return;
            }
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (this.next == null && node.getStartOffset() >= this.offset) {
                if (this.container != null && this.container == node.rParent) {
                    this.next = node;
                    return;
                }
                node.acceptInRChildren(this);
                return;
            }
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            if (this.next == null) {
                if (node.getStartOffset() >= this.offset) {
                    if (this.container != null && this.container == node.rParent) {
                        this.next = node;
                        return;
                    }
                    node.acceptInRChildren(this);
                    return;
                }
                if (node.getEndOffset() >= this.offset) {
                    this.container = node;
                    node.acceptInRChildren(this);
                    return;
                }
            }
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            if (this.next == null) {
                AstNode parent = node.getParent();
                if (node.getEndOffset() >= this.offset && (parent == null || parent.getStartOffset() <= this.offset && this.offset <= parent.getEndOffset())) {
                    this.container = node;
                    node.acceptInRChildren(this);
                    return;
                }
            }
        }
    }
}

