/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.core;

import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.BasicProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.IProgressInfo;

@NonNullByDefault
public class RunnableProgressData
extends BasicProgressMonitor.ProgressData
implements IProgressInfo {
    private final @Nullable ToolRunnable runnable;
    private @Nullable String label;
    private volatile boolean refreshLabel;
    private @Nullable ProgressMonitor root;

    public RunnableProgressData(ToolRunnable runnable) {
        this.runnable = runnable;
        this.setMainTaskName(runnable.getLabel());
    }

    public RunnableProgressData(String name) {
        this.runnable = null;
        this.setMainTaskName(name);
    }

    public void setCanceled(boolean state) {
        super.setCanceled(state);
    }

    protected void onDataChanged(byte data) {
        switch (data) {
            case 2: 
            case 32: 
            case 64: {
                this.refreshLabel = true;
                break;
            }
        }
    }

    @Override
    public String getLabel() {
        String label = this.label;
        if (this.refreshLabel || label == null) {
            this.refreshLabel = false;
            this.label = label = this.createLabelWithStatus();
        }
        return label;
    }

    private String createLabelWithStatus() {
        String mainTaskName = (String)ObjectUtils.nonNullElse((Object)this.getMainTaskName(), (Object)"");
        if (this.isCanceled()) {
            return NLS.bind((String)Messages.Progress_Canceled_label, (Object)mainTaskName);
        }
        Status blocked = this.getBlocked();
        if (blocked != null) {
            return NLS.bind((String)Messages.Progress_Blocked_label, (Object[])new Object[]{mainTaskName, blocked.getMessage()});
        }
        return mainTaskName;
    }

    @Override
    public String getSubLabel() {
        return (String)ObjectUtils.nonNullElse((Object)this.getSubTaskName(), (Object)"");
    }

    @Override
    public @Nullable ToolRunnable getRunnable() {
        return this.runnable;
    }

    @Override
    public double getWorked() {
        if (this.isProgressUnknown()) {
            return -1.0;
        }
        return 1.0 - this.getProgress();
    }

    public ProgressMonitor getRoot() {
        ProgressMonitor root = this.root;
        if (root == null) {
            this.root = root = new BasicProgressMonitor((BasicProgressMonitor.ProgressData)this, 2);
        }
        return root;
    }
}

