/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.issues.core.Issue;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.Task;

@NonNullByDefault
public class IssueTypeSet {
    private final String sourceId;
    private final TaskCategory taskCategory;
    private final ImList<ProblemCategory> problemCategories;
    private final ImIdentitySet<String> persistenceTypes;
    private final ImIdentitySet<String> editorTypes;

    public IssueTypeSet(String sourceId, TaskCategory taskCategory, ImList<ProblemCategory> problemCategories) {
        this.sourceId = sourceId;
        this.taskCategory = taskCategory;
        this.problemCategories = problemCategories;
        ArrayList<String> list = new ArrayList<String>();
        this.collectAllTypes(list, Ltk.PERSISTENCE_CONTEXT);
        this.persistenceTypes = ImCollections.toIdentitySet(list);
        list.clear();
        this.collectAllTypes(list, Ltk.EDITOR_CONTEXT);
        this.editorTypes = ImCollections.toIdentitySet(list);
    }

    public IssueTypeSet(String sourceId, IssueTypeSet baseSet, ProblemCategory ... addProblemCategories) {
        this(sourceId, baseSet.taskCategory, (ImList<ProblemCategory>)ImCollections.concatList(baseSet.problemCategories, (Collection)ImCollections.newList((Object[])addProblemCategories)));
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public TaskCategory getTaskCategory() {
        return this.taskCategory;
    }

    public ImList<ProblemCategory> getProblemCategories() {
        return this.problemCategories;
    }

    public @Nullable ProblemCategory getProblemCategory(String categoryId) {
        for (ProblemCategory category : this.problemCategories) {
            if (category.id != categoryId) continue;
            return category;
        }
        return null;
    }

    public @Nullable IssueCategory<?> getCategory(WorkingContext context, String type) {
        ImIdentitySet<String> allTypes = this.getAllTypes(context);
        if (allTypes == null || !allTypes.contains((Object)type)) {
            return null;
        }
        IssueCategory<Task> category2 = this.getTaskCategory();
        if (type.equals(((TaskCategory)category2).getType(context))) {
            return category2;
        }
        for (IssueCategory<Task> category2 : this.getProblemCategories()) {
            ProblemTypes problemTypes = ((ProblemCategory)category2).getTypes(context);
            if (problemTypes == null || !type.equals(problemTypes.errorType) && !type.equals(problemTypes.warningType) && !type.equals(problemTypes.infoType)) continue;
            return category2;
        }
        return null;
    }

    private void collectAllTypes(Collection<String> types, WorkingContext context) {
        String type = this.getTaskCategory().getType(context);
        if (type != null) {
            types.add(type);
        }
        for (ProblemCategory category : this.getProblemCategories()) {
            ProblemTypes problemTypes = category.getTypes(context);
            if (problemTypes == null) continue;
            types.add(problemTypes.errorType);
            types.add(problemTypes.warningType);
            types.add(problemTypes.infoType);
        }
    }

    public @Nullable ImIdentitySet<String> getAllTypes(WorkingContext context) {
        if (context == Ltk.PERSISTENCE_CONTEXT) {
            return this.persistenceTypes;
        }
        if (context == Ltk.EDITOR_CONTEXT) {
            return this.editorTypes;
        }
        return null;
    }

    public static interface IssueCategory<TIssue extends Issue> {
        public @Nullable String mapType(WorkingContext var1, WorkingContext var2, String var3);
    }

    public static class ProblemCategory
    implements IssueCategory<Problem> {
        private final String id;
        private final @Nullable ProblemTypes persistenceTypes;
        private final @Nullable ProblemTypes editorTypes;

        public ProblemCategory(String id, @Nullable ProblemTypes persistenceTypes, @Nullable ProblemTypes editorTypes) {
            this.id = id;
            this.persistenceTypes = persistenceTypes;
            this.editorTypes = editorTypes;
        }

        public String getId() {
            return this.id;
        }

        public @Nullable ProblemTypes getTypes(WorkingContext context) {
            if (context == Ltk.PERSISTENCE_CONTEXT) {
                return this.persistenceTypes;
            }
            if (context == Ltk.EDITOR_CONTEXT) {
                return this.editorTypes;
            }
            return null;
        }

        @Override
        public @Nullable String mapType(WorkingContext fromContext, WorkingContext toContext, String type) {
            byte severity;
            ProblemTypes problemTypes = this.getTypes(fromContext);
            if (problemTypes != null && (severity = problemTypes.getSeverity(type)) != -1 && (problemTypes = this.getTypes(toContext)) != null) {
                return problemTypes.getType(severity);
            }
            return null;
        }
    }

    public static final class ProblemTypes {
        private final String errorType;
        private final String warningType;
        private final String infoType;

        public ProblemTypes(String errorType, String warningType, String infoType) {
            this.errorType = errorType;
            this.warningType = warningType;
            this.infoType = infoType;
        }

        public ProblemTypes(String type) {
            this.errorType = type;
            this.warningType = type;
            this.infoType = type;
        }

        public String getType(int severity) {
            switch (severity) {
                case 2: {
                    return this.errorType;
                }
                case 1: {
                    return this.warningType;
                }
            }
            return this.infoType;
        }

        public byte getSeverity(String type) {
            if (type == this.errorType) {
                return 2;
            }
            if (type == this.warningType) {
                return 1;
            }
            if (type == this.infoType) {
                return 0;
            }
            return -1;
        }
    }

    public static class TaskCategory
    implements IssueCategory<Task> {
        private final @Nullable String persistenceType;
        private final @Nullable String editorType;

        public TaskCategory(@Nullable String persistenceType, @Nullable String editorType) {
            this.persistenceType = persistenceType;
            this.editorType = editorType;
        }

        public @Nullable String getType(WorkingContext context) {
            if (context == Ltk.PERSISTENCE_CONTEXT) {
                return this.persistenceType;
            }
            if (context == Ltk.EDITOR_CONTEXT) {
                return this.editorType;
            }
            return null;
        }

        @Override
        public @Nullable String mapType(WorkingContext fromContext, WorkingContext toContext, String type) {
            String taskType = this.getType(fromContext);
            if (taskType != null && taskType == type) {
                return this.getType(toContext);
            }
            return null;
        }
    }
}

