/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.io;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.statet.internal.jcommons.io.JarStringUrl;
import org.eclipse.statet.internal.jcommons.io.JarUriUrl;
import org.eclipse.statet.internal.jcommons.io.NestedJarBoot2StringUrl;
import org.eclipse.statet.internal.jcommons.io.NestedJarBoot2UriUrl;
import org.eclipse.statet.internal.jcommons.io.NestedJarStringUrl;
import org.eclipse.statet.internal.jcommons.io.NestedJarUriUrl;
import org.eclipse.statet.jcommons.io.ArchiveUrl;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class CommonsUriInternals {
    public static final String NESTED_SCHEME = "nested";
    public static final String JAR_NESTED_SEPARATOR = "/!";
    private static final boolean NESTED_JAR_BOOT2_ENABLED = true;

    public static boolean startsWithScheme(String urlString, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= n) {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean startsWithScheme(String urlString, int offset, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= offset + n) {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(offset + index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isSchemeUrl(String urlString, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= n || urlString.charAt(n) != ':') {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isSchemeUrl(String urlString, int offset, String expectedScheme) {
        int n = expectedScheme.length();
        if (urlString.length() <= offset + n || urlString.charAt(offset + n) != ':') {
            return false;
        }
        int index = 0;
        while (index < n) {
            char cExpected;
            char c = urlString.charAt(offset + index);
            if (c != (cExpected = expectedScheme.charAt(index)) && Character.toLowerCase(c) != cExpected) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static ArchiveUrl createJarArchiveUrl(String urlString) throws URISyntaxException {
        int schemeSep2Idx = urlString.indexOf(58, 4);
        if (schemeSep2Idx == -1 || !UriUtils.isValidScheme(urlString, 4, schemeSep2Idx)) {
            throw new URISyntaxException(urlString, "Valid scheme for JAR file is missing", 4);
        }
        int jarSep1Idx = urlString.indexOf("!/", schemeSep2Idx + 1);
        if (jarSep1Idx == -1) {
            throw new URISyntaxException(urlString, "JAR content separator '!/' is missing");
        }
        if (schemeSep2Idx == 10 && CommonsUriInternals.startsWithScheme(urlString, 4, NESTED_SCHEME)) {
            return new NestedJarStringUrl(urlString, jarSep1Idx);
        }
        int jarSep2Idx = urlString.indexOf("!/", jarSep1Idx + 2);
        if (jarSep2Idx != -1) {
            if (schemeSep2Idx == 8 && CommonsUriInternals.startsWithScheme(urlString, 4, "file")) {
                return new NestedJarBoot2StringUrl(urlString, jarSep1Idx, jarSep2Idx);
            }
            throw new URISyntaxException(urlString, "Unknown/Unsupported JAR URL type", 4);
        }
        return new JarStringUrl(urlString, schemeSep2Idx, jarSep1Idx);
    }

    public static ArchiveUrl createJarArchiveUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        int schemeSep2Idx = ssp.indexOf(58);
        if (schemeSep2Idx == -1 || !UriUtils.isValidScheme(ssp, 0, schemeSep2Idx)) {
            throw new URISyntaxException(url.toString(), "Valid scheme for JAR file is missing");
        }
        int jarSep1Idx = ssp.indexOf("!/", schemeSep2Idx + 1);
        if (jarSep1Idx == -1) {
            throw new URISyntaxException(url.toString(), "JAR content separator '!/' is missing");
        }
        if (schemeSep2Idx == 6 && CommonsUriInternals.startsWithScheme(ssp, NESTED_SCHEME)) {
            return new NestedJarUriUrl(url, jarSep1Idx);
        }
        int jarSep2Idx = ssp.indexOf("!/", jarSep1Idx + 2);
        if (jarSep2Idx != -1) {
            if (schemeSep2Idx == 4 && CommonsUriInternals.startsWithScheme(ssp, "file")) {
                return new NestedJarBoot2UriUrl(url, jarSep1Idx, jarSep2Idx);
            }
            throw new URISyntaxException(url.toString(), "Unknown/Unsupported JAR URL type", 4);
        }
        return new JarUriUrl(url, schemeSep2Idx, jarSep1Idx);
    }

    private CommonsUriInternals() {
    }
}

