/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.net.core.sshd;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.statet.internal.ecommons.net.core.ESshSettings;
import org.eclipse.statet.internal.ecommons.net.core.sshd.EConnectoryFactory;
import org.eclipse.statet.internal.ecommons.net.core.sshd.EIdentityPasswordProvider;
import org.eclipse.statet.internal.ecommons.net.core.sshd.EProxyDataFactory;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.core.ssh.sshd.SshdClientSessionFactory;

@NonNullByDefault
public class ESshdClientSessionFactory
extends SshdClientSessionFactory {
    private final ESshSettings sshSettings;

    public ESshdClientSessionFactory(ESshSettings settings, @Nullable IProxyService proxyService) {
        super((ProxyDataFactory)(proxyService != null ? new EProxyDataFactory(proxyService) : null));
        this.sshSettings = settings;
    }

    protected Path getSshDataDirectory() {
        Path directory = this.sshSettings.getSshDataDirectory();
        if (directory != null) {
            return directory;
        }
        return super.getSshDataDirectory();
    }

    protected List<Path> getDefaultIdentities(SshdClientSessionFactory.ConfigBase configBase) {
        ImList<String> identityNames = this.sshSettings.getDefaultIdentityNames();
        if (identityNames != null) {
            return FileUtils.getRegularFiles((Path)configBase.getSshDataDir(), identityNames);
        }
        return super.getDefaultIdentities(configBase);
    }

    protected @Nullable String getDefaultPreferredAuthenticationMethodsString() {
        return this.sshSettings.getPreferredAuthenticationMethodsString();
    }

    protected @Nullable KeyPasswordProvider createKeyPasswordProvider(@Nullable CredentialsProvider credentialsProvider) {
        return new EIdentityPasswordProvider(credentialsProvider, this.sshSettings);
    }

    protected @Nullable ConnectorFactory getConnectorFactory() {
        ConnectorFactory connectorFactory;
        if (this.sshSettings.isUseIdentityAgentEnabled() && (connectorFactory = super.getConnectorFactory()) != null) {
            return new EConnectoryFactory(connectorFactory, this.sshSettings);
        }
        return null;
    }
}

