/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.validation;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public class ConverterValidator<T>
implements IValidator<T> {
    private final IConverter<T, ?> converter;

    public ConverterValidator(IConverter<T, ?> converter) {
        this.converter = converter;
    }

    public IStatus validate(T value) {
        try {
            this.converter.convert(value);
            return ValidationStatus.ok();
        }
        catch (IllegalArgumentException e) {
            return ValidationStatus.error((String)e.getLocalizedMessage());
        }
    }
}

