/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.conversion;

import java.util.function.Function;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE})
public interface ClassTypedConverter<F, T>
extends IConverter<F, T> {
    public Class<F> getFromType();

    public Class<T> getToType();

    public static <F, T> ClassTypedConverter<F, T> create(final Class<F> fromType, final Class<T> toType, final Function<? super F, ? extends T> function) {
        return new ClassTypedConverter<F, T>(){

            @Override
            public Class<F> getFromType() {
                return fromType;
            }

            @Override
            public Class<T> getToType() {
                return toType;
            }

            public T convert(F fromObject) {
                return function.apply(fromObject);
            }
        };
    }

    public static <F, T> ClassTypedConverter<F, T> createIdentity(final Class<F> fromType, final Class<T> toType) {
        return new ClassTypedConverter<F, T>(){

            @Override
            public Class<F> getFromType() {
                return fromType;
            }

            @Override
            public Class<T> getToType() {
                return toType;
            }

            public T convert(F fromObject) {
                return fromObject;
            }
        };
    }

    public static <T> ClassTypedConverter<T, T> createIdentity(Class<T> type) {
        return ClassTypedConverter.createIdentity(type, type);
    }
}

