/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.PreferencesManageListener;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;

final class BasicWikitextCoreAccess
implements WikitextCoreAccess {
    private boolean isDisposed;
    private final PreferenceAccess prefs;
    private PreferencesManageListener codeStyleListener;
    private WikitextCodeStyleSettings codeStyle;

    public BasicWikitextCoreAccess(PreferenceAccess prefs) {
        this.prefs = prefs;
        this.codeStyle = new WikitextCodeStyleSettings(1);
        this.codeStyleListener = new PreferencesManageListener((AbstractPreferencesModelObject)this.codeStyle, this.prefs, WikitextCodeStyleSettings.ALL_GROUP_IDS);
        this.codeStyle.load(prefs);
        this.codeStyle.resetDirty();
    }

    @Override
    public PreferenceAccess getPrefs() {
        return this.prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WikitextCodeStyleSettings getWikitextCodeStyle() {
        WikitextCodeStyleSettings codeStyle = this.codeStyle;
        if (codeStyle == null) {
            BasicWikitextCoreAccess basicWikitextCoreAccess = this;
            synchronized (basicWikitextCoreAccess) {
                codeStyle = this.codeStyle;
                if (codeStyle == null) {
                    codeStyle = new WikitextCodeStyleSettings(1);
                    if (!this.isDisposed) {
                        this.codeStyleListener = new PreferencesManageListener((AbstractPreferencesModelObject)codeStyle, this.prefs, WikitextCodeStyleSettings.ALL_GROUP_IDS);
                    }
                    codeStyle.load(this.prefs);
                    codeStyle.resetDirty();
                    this.codeStyle = codeStyle;
                }
            }
        }
        return codeStyle;
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.codeStyleListener != null) {
            this.codeStyleListener.dispose();
            this.codeStyleListener = null;
        }
    }
}

