/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.ts.core.console;

import java.util.regex.Matcher;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.console.ConsoleService;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.statet.rj.util.RCodeBuilder;

@NonNullByDefault
public interface RConsoleService
extends RToolService,
ConsoleService {
    public static final int AUTO_CHANGE = 1;
    public static final int PACKAGE_CHANGE = 16;

    default public void handleStatus(Status status, ProgressMonitor m) {
        if (status == null || status.getSeverity() == 0) {
            return;
        }
        try {
            String br = "\n";
            String br1 = "\n    ";
            String br2 = "\n        ";
            StringBuilder msg = new StringBuilder("\n");
            boolean details = false;
            switch (status.getSeverity()) {
                case 1: {
                    msg.append("[INFO   ] ");
                    break;
                }
                case 2: {
                    msg.append("[WARNING] ");
                    break;
                }
                case 4: {
                    msg.append("[ERROR  ] ");
                    break;
                }
                case 8: {
                    msg.append("[CANCEL ] ");
                }
            }
            msg.append(status.getMessage());
            ImList subList = null;
            if (status.isMultiStatus()) {
                details |= status.getException() != null;
                subList = status.getChildren();
            } else {
                Throwable exception = status.getException();
                if (exception instanceof StatusException) {
                    subList = ImCollections.newList((Object)((StatusException)exception).getStatus());
                } else if (exception != null) {
                    details = true;
                }
            }
            if (subList != null && !subList.isEmpty()) {
                Matcher linebreakMatcher = StringUtils.U_LINEBREAK_PATTERN.matcher("");
                for (Status subStatus : subList) {
                    msg.append("\n    ");
                    msg.append(linebreakMatcher.reset(subStatus.getMessage()).replaceAll("\n        "));
                    details |= subStatus.isMultiStatus() || subStatus.getException() != null;
                }
            }
            msg.append("\n");
            this.submitToConsole(new RCodeBuilder().append("cat(").appendChar(msg).append(")").build(), m);
        }
        catch (Exception e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", "An error occured when reporting status to R console.", (Throwable)e));
        }
    }

    public void briefAboutToChange();

    public void briefChanged(int var1);
}

