/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.util.LoadReferencesUtil;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RFrameSearchPath;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.RLexer;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.sourceediting.WorkbenchRFrameSearchPath;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class RAssistInvocationContext
extends AssistInvocationContext {
    private static final byte PARSE_OPERATOR = 1;
    private static final byte PARSE_SYMBOL = 2;
    private @Nullable RHeuristicTokenScanner scanner;
    private @Nullable RLexer lexer;
    private @Nullable RElementName prefixName;
    private int prefixLastSegmentOffset = -1;
    private final @Nullable RProcess tool;
    private @Nullable LoadReferencesUtil toolReferencesUtil;

    public RAssistInvocationContext(SourceEditor editor, int offset, String contentType, boolean isProposal, @Nullable RHeuristicTokenScanner scanner, IProgressMonitor monitor) {
        super(editor, offset, contentType, isProposal ? 2 : 0, monitor);
        this.scanner = scanner;
        this.tool = this.determineRProcess();
    }

    public RAssistInvocationContext(SourceEditor editor, IRegion region, String contentType, @Nullable RHeuristicTokenScanner scanner, IProgressMonitor monitor) {
        super(editor, region, contentType, 2, monitor);
        this.scanner = scanner;
        this.tool = this.determineRProcess();
    }

    public RAssistInvocationContext(AssistInvocationContext base, boolean isProposal, IProgressMonitor monitor) {
        super(base, isProposal ? 2 : 0, monitor);
        this.tool = this.determineRProcess();
    }

    private @Nullable RProcess determineRProcess() {
        SourceEditor editor = this.getEditor();
        Tool tool = editor instanceof ConsolePageEditor ? (Tool)editor.getAdapter(Tool.class) : NicoUITools.getTool((IWorkbenchPart)editor.getWorkbenchPart());
        return tool instanceof RProcess ? (RProcess)tool : null;
    }

    protected boolean reuse(SourceEditor editor, int offset) {
        if (super.reuse(editor, offset)) {
            LoadReferencesUtil toolReferencesUtil = this.toolReferencesUtil;
            if (toolReferencesUtil != null) {
                toolReferencesUtil.setWaitTimeout((long)this.getToolReferencesWaitTimeout());
            }
            return true;
        }
        return false;
    }

    protected String getModelTypeId() {
        return "R";
    }

    public @Nullable RSourceUnit getSourceUnit() {
        return (RSourceUnit)super.getSourceUnit();
    }

    public RCoreAccess getRCoreAccess() {
        return RCore.getContextAccess((IAdaptable)this.getEditor());
    }

    public int getTabWidth() {
        return this.getRCoreAccess().getRCodeStyle().getTabWidth();
    }

    public final RHeuristicTokenScanner getRHeuristicTokenScanner() {
        RHeuristicTokenScanner scanner = this.scanner;
        if (scanner == null) {
            this.scanner = scanner = RHeuristicTokenScanner.create((DocContentSections)this.getEditor().getDocumentContentInfo());
        }
        return scanner;
    }

    protected RLexer getLexer() {
        RLexer lexer = this.lexer;
        if (lexer == null) {
            lexer = new RLexer(32775);
            lexer.reset((TextParserInput)new StringParserInput());
            this.lexer = lexer;
        }
        return lexer;
    }

    public @Nullable RAstNode getInvocationRAstNode() {
        AstNode node = this.getInvocationAstSelection().getCovering();
        if (node == null) {
            node = this.getAstInfo().getRoot();
        }
        return node instanceof RAstNode ? (RAstNode)node : null;
    }

    public @Nullable RAstNode getSelectionRAstNode() {
        AstNode node = this.getAstSelection().getCovering();
        return node instanceof RAstNode ? (RAstNode)node : null;
    }

    protected String computeIdentifierPrefix(int endOffset) throws BadPartitioningException, BadLocationException {
        AbstractDocument document = (AbstractDocument)this.getDocument();
        if (endOffset < 0 || endOffset > document.getLength()) {
            throw new BadLocationException("offset= " + endOffset);
        }
        if (endOffset == 0) {
            return "";
        }
        int offset = endOffset;
        int currentMode = 3;
        int validModes = 3;
        String partitioning = this.getEditor().getDocumentContentInfo().getPartitioning();
        ITypedRegion partition = document.getPartition(partitioning, offset, true);
        if (partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") {
            offset = partition.getOffset();
            currentMode = 1;
        }
        int startOffset = offset;
        block5: while (offset > 0) {
            char c = document.getChar(offset - 1);
            if (RTokens.isRobustSeparator((int)c)) {
                switch (c) {
                    case '$': 
                    case '@': {
                        if ((currentMode & 1) == 0) break block5;
                        startOffset = --offset;
                        currentMode = (byte)(validModes & 2);
                        continue block5;
                    }
                    case ':': {
                        if ((currentMode & 1) == 0 || offset < 2 || document.getChar(offset - 2) != ':') break block5;
                        offset = offset >= 3 && document.getChar(offset - 3) == ':' ? (offset -= 3) : (offset -= 2);
                        validModes = (byte)(validModes & 0xFFFFFFFE);
                        currentMode = (byte)(validModes & 2);
                        continue block5;
                    }
                    case '`': {
                        if ((currentMode & 2) == 0 || (partition = document.getPartition(partitioning, offset - 1, false)).getType() != "R.QuotedSymbol") break block5;
                        startOffset = offset = partition.getOffset();
                        currentMode = (byte)(validModes & 1);
                        continue block5;
                    }
                }
                break;
            }
            if ((currentMode & 2) == 0) break;
            startOffset = --offset;
            currentMode = (byte)(currentMode | (byte)(validModes & 1));
        }
        return document.get(startOffset, endOffset - startOffset);
    }

    protected int computeIdentifierPrefixLastSegmentOffset(int endOffset) throws BadPartitioningException, BadLocationException {
        AbstractDocument document = (AbstractDocument)this.getDocument();
        if (endOffset < 0 || endOffset > document.getLength()) {
            throw new BadLocationException("endOffset= " + endOffset);
        }
        if (endOffset == 0) {
            return 0;
        }
        int offset = endOffset;
        String partitioning = this.getEditor().getDocumentContentInfo().getPartitioning();
        ITypedRegion partition = document.getPartition(partitioning, offset, true);
        if (partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") {
            return partition.getOffset();
        }
        int startOffset = offset;
        while (offset > 0) {
            char c = document.getChar(offset - 1);
            if (RTokens.isRobustSeparator((int)c, (boolean)false)) break;
            startOffset = --offset;
        }
        return startOffset;
    }

    public @Nullable RElementName getIdentifierElementName() {
        if (this.prefixName == null) {
            this.prefixName = RElementName.parseDefault((String)this.getIdentifierPrefix());
        }
        return this.prefixName;
    }

    public int getIdentifierLastSegmentOffset() {
        if (this.prefixLastSegmentOffset < 0) {
            try {
                this.prefixLastSegmentOffset = this.computeIdentifierPrefixLastSegmentOffset(this.getInvocationOffset());
            }
            catch (BadLocationException | BadPartitioningException e) {
                this.prefixLastSegmentOffset = this.getInvocationOffset();
                throw new RuntimeException(e);
            }
        }
        return this.prefixLastSegmentOffset;
    }

    public @Nullable String getIdentifierSegmentName(String source) {
        RLexer lexer = this.getLexer();
        ((StringParserInput)lexer.getInput()).reset(source).init();
        lexer.reset();
        switch (lexer.next()) {
            case EOF: {
                return "";
            }
        }
        return lexer.getText();
    }

    private static @Nullable RElementName getElementAccessOfRegion(RElementAccess access, TextRegion region) {
        RElementAccess current = access;
        while (current != null) {
            if (current.getSegmentName() == null) {
                return null;
            }
            switch (current.getType()) {
                case 17: 
                case 21: 
                case 25: 
                case 26: 
                case 33: 
                case 34: 
                case 37: 
                case 38: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RAstNode nameNode = current.getNameNode();
            if (nameNode != null && nameNode.getStartOffset() <= region.getStartOffset() && nameNode.getEndOffset() >= region.getEndOffset()) {
                return RElementName.create((RElementName)access, (RElementName)current.getNextSegment(), (boolean)true);
            }
            current = current.getNextSegment();
        }
        return null;
    }

    public @Nullable RElementName getNameSelection() {
        AstNode selectedNode = this.getAstSelection().getCovering();
        if (selectedNode instanceof RAstNode) {
            RAstNode node = (RAstNode)selectedNode;
            RElementAccess access = null;
            while (node != null && access == null) {
                if (Thread.interrupted()) {
                    return null;
                }
                ImList attachments = node.getAttachments();
                for (Object attachment : attachments) {
                    if (!(attachment instanceof RElementAccess)) continue;
                    node = null;
                    access = (RElementAccess)attachment;
                    RElementName e = RAssistInvocationContext.getElementAccessOfRegion(access, (TextRegion)this);
                    if (e != null) {
                        return e;
                    }
                    if (!Thread.interrupted()) continue;
                    return null;
                }
                if (node == null) continue;
                node = node.getRParent();
            }
        }
        return null;
    }

    public @Nullable FCallInfo createFCallInfo(@Nullable FCall fCallNode) {
        if (fCallNode != null) {
            ImList attachments = fCallNode.getAttachments();
            for (Object attachment : attachments) {
                RElementAccess fcallAccess;
                if (!(attachment instanceof RElementAccess) || (fcallAccess = (RElementAccess)attachment).getNode() != fCallNode || !fcallAccess.isFunctionAccess() || fcallAccess.isWriteAccess()) continue;
                return new FCallInfo(fCallNode, fcallAccess);
            }
        }
        return null;
    }

    public @Nullable FCallInfo getFCallInfo() {
        int endOffset = this.findRelevantOffsetBackward(this.getEndOffset());
        int startOffset = Math.min(this.getStartOffset(), endOffset);
        return this.createFCallInfo(this.searchFCallByArgsRegion(startOffset, endOffset));
    }

    private int findRelevantOffsetBackward(int offset) {
        int docOffset = offset;
        int docOffsetShift = 0;
        IDocument document = this.getDocument();
        if (document instanceof FragmentDocument) {
            FragmentDocument fragmentDoc = (FragmentDocument)document;
            document = fragmentDoc.getMasterDocument();
            docOffsetShift = fragmentDoc.getOffsetInMasterDocument();
            docOffset += docOffsetShift;
        }
        if (docOffset > 0) {
            try {
                RHeuristicTokenScanner scanner = this.getRHeuristicTokenScanner();
                int bound = document.getLineOffset(Math.max(document.getLineOfOffset(docOffset) - 2, 0));
                scanner.configure(document, RDocumentConstants.R_NO_COMMENT_CONTENT_CONSTRAINT);
                docOffset = scanner.findNonMSpaceBackward(docOffset, bound);
                if (docOffset != -1) {
                    return docOffset + 1 - docOffsetShift;
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logUncriticalError(e);
            }
        }
        return offset;
    }

    private @Nullable FCall searchFCallByArgsRegion(int startOffset, int endOffset) {
        AstInfo astInfo = this.getAstInfo();
        if (astInfo == null || astInfo.getRoot() == null) {
            return null;
        }
        AstSelection selection = AstSelection.search((AstNode)astInfo.getRoot(), (int)startOffset, (int)endOffset, (int)3);
        AstNode node = selection.getCovering();
        if (node instanceof RAstNode) {
            RAstNode rNode = (RAstNode)node;
            do {
                FCall fCallNode;
                if (rNode.getNodeType() != NodeType.F_CALL || (fCallNode = (FCall)rNode).getArgsOpenOffset() == Integer.MIN_VALUE || fCallNode.getArgsOpenOffset() >= startOffset || fCallNode.getArgsCloseOffset() != Integer.MIN_VALUE && fCallNode.getArgsCloseOffset() < endOffset) continue;
                return fCallNode;
            } while ((rNode = rNode.getRParent()) != null);
        }
        return null;
    }

    public @Nullable RProcess getTool() {
        return this.tool;
    }

    public boolean isToolConsole() {
        return this.getEditor() instanceof ConsolePageEditor;
    }

    public LoadReferencesUtil getToolReferencesUtil() {
        assert (this.tool != null);
        LoadReferencesUtil util = this.toolReferencesUtil;
        if (util == null) {
            this.toolReferencesUtil = util = new LoadReferencesUtil(this.tool, this.getToolReferencesWaitTimeout()){

                protected void allFinished(ImList<CombinedRElement> resolvedElements) {
                    if (!resolvedElements.isEmpty()) {
                        RAssistInvocationContext.this.toolReferencesResolved(resolvedElements);
                    }
                }
            };
        }
        return util;
    }

    protected int getToolReferencesWaitTimeout() {
        return 250;
    }

    protected void toolReferencesResolved(ImList<CombinedRElement> resolvedElements) {
    }

    public int getDefaultRFrameSearchMode() {
        return this.isToolConsole() ? 2 : 1;
    }

    public class FCallInfo {
        private final FCall node;
        private final RElementAccess access;
        private final int invocationArgIdx;
        private @Nullable RFrameSearchPath searchPath;

        public FCallInfo(FCall node, RElementAccess access) {
            this.node = node;
            this.access = access;
            this.invocationArgIdx = this.getArgIdx(RAssistInvocationContext.this.getInvocationOffset());
        }

        public FCall getNode() {
            return this.node;
        }

        public RElementAccess getAccess() {
            return this.access;
        }

        private RFrameSearchPath createSearchPath(int mode) {
            WorkbenchRFrameSearchPath searchPath = new WorkbenchRFrameSearchPath();
            RAstNode parent = this.node.getRParent();
            searchPath.init(RAssistInvocationContext.this, (RAstNode)(parent != null ? parent : this.node), mode, this.getAccess().getScope());
            return searchPath;
        }

        public RFrameSearchPath getSearchPath(int mode) {
            int defaultMode = RAssistInvocationContext.this.getDefaultRFrameSearchMode();
            if (mode == 0 || mode == defaultMode) {
                @Nullable RFrameSearchPath searchPath = this.searchPath;
                if (searchPath == null) {
                    this.searchPath = searchPath = this.createSearchPath(defaultMode);
                }
                return searchPath;
            }
            return this.createSearchPath(mode);
        }

        public int getArgIdx(int offset) {
            if (offset <= this.node.getArgsOpenOffset() || this.node.getArgsCloseOffset() != Integer.MIN_VALUE && offset > this.node.getArgsCloseOffset()) {
                return -1;
            }
            FCall.Args args = this.node.getArgsChild();
            int last = args.getChildCount() - 1;
            if (last < 0) {
                return 0;
            }
            int argIdx = 0;
            while (argIdx < last) {
                if (args.getSeparatorOffsets().getAt(argIdx) >= offset) {
                    return argIdx;
                }
                ++argIdx;
            }
            return last;
        }

        public int getArgBeginOffset(int argIdx) {
            if (argIdx < 0) {
                return Integer.MIN_VALUE;
            }
            int sep = argIdx == 0 ? this.node.getArgsOpenOffset() : this.node.getArgsChild().getSeparatorOffsets().getAt(argIdx - 1);
            return sep + 1;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable FCall.Arg getArg(int argIdx) {
            if (argIdx < 0) {
                return null;
            }
            FCall.Args args = this.node.getArgsChild();
            return argIdx < args.getChildCount() ? args.getChild(argIdx) : null;
        }

        public final int getInvocationArgIdx() {
            return this.invocationArgIdx;
        }
    }
}

