/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.util.Version;

@NonNullByDefault
public interface RSourceConstants {
    public static final Version LANG_VERSION_4_0 = new Version(4, 0, 0);
    public static final Version LANG_VERSION_4_1 = new Version(4, 1, 0);
    public static final Version LANG_VERSION_4_2 = new Version(4, 2, 0);
    public static final Version LANG_VERSION_4_3 = new Version(4, 3, 0);
    public static final Version LANG_VERSION_4_4 = new Version(4, 4, 0);
    public static final ImList<Version> LANG_VERSIONS = ImCollections.newList((Object[])new Version[]{LANG_VERSION_4_4, LANG_VERSION_4_3, LANG_VERSION_4_2, LANG_VERSION_4_1, LANG_VERSION_4_0});
    public static final int TYPE1_SYNTAX_INCORRECT_TOKEN = 256;
    public static final int TYPE12_SYNTAX_TOKEN_OPENING_INCOMPLETE = 0x400110;
    public static final int TYPE12_SYNTAX_TOKEN_NOT_CLOSED = 4194592;
    public static final int TYPE12_SYNTAX_SYMBOL_INVALID = 0x400140;
    public static final int TYPE123_SYNTAX_SYMBOL_START_INVALID = 0x400141;
    public static final int TYPE12_SYNTAX_NUMBER_INVALID = 4194640;
    public static final int TYPE123_SYNTAX_NUMBER_HEX_DIGIT_MISSING = 4194645;
    public static final int TYPE123_SYNTAX_NUMBER_HEX_FLOAT_EXP_MISSING = 4194646;
    public static final int TYPE123_SYNTAX_NUMBER_EXP_DIGIT_MISSING = 4194647;
    public static final int TYPE12_SYNTAX_NUMBER_MISLEADING = 352;
    public static final int TYPE123_SYNTAX_NUMBER_NON_INT_WITH_L = 353;
    public static final int TYPE123_SYNTAX_NUMBER_INT_WITH_DEC_POINT = 354;
    public static final int TYPE12_SYNTAX_TEXT_INVALID = 4194672;
    public static final int TYPE123_SYNTAX_TEXT_NULLCHAR = 4194673;
    public static final int TYPE123_SYNTAX_TEXT_ESCAPE_SEQ_UNEXPECTED = 4194675;
    public static final int TYPE123_SYNTAX_TEXT_ESCAPE_SEQ_NOT_CLOSED = 4194676;
    public static final int TYPE123_SYNTAX_TEXT_ESCAPE_SEQ_HEX_DIGIT_MISSING = 4194677;
    public static final int TYPE123_SYNTAX_TEXT_ESCAPE_SEQ_UNKOWN = 4194681;
    public static final int TYPE123_SYNTAX_TEXT_ESCAPE_SEQ_CODEPOINT_INVALID = 4194683;
    public static final int TYPE12_SYNTAX_TOKEN_UNKNOWN = 4194704;
    public static final int TYPE12_SYNTAX_TOKEN_UNEXPECTED = 4194720;
    public static final int TYPE123_SYNTAX_TOKEN_MULTI_UNEXPECTED = 4194722;
    public static final int TYPE123_SYNTAX_TOKEN_UNNAMED_UNEXPECTED = 4194723;
    public static final int TYPE123_SYNTAX_SEQREL_UNEXPECTED = 4194731;
    public static final int TYPE12_SYNTAX_FCALL_AFTER_OP_EXPR_UNEXPECTED = 4194736;
    public static final int TYPE1_SYNTAX_MISSING_TOKEN = 768;
    public static final int TYPE12_SYNTAX_EXPR_MISSING = 4195088;
    public static final int TYPE123_SYNTAX_EXPR_AS_REF_MISSING = 4195089;
    public static final int TYPE123_SYNTAX_EXPR_BEFORE_OP_MISSING = 4195090;
    public static final int TYPE123_SYNTAX_EXPR_AFTER_OP_MISSING = 4195091;
    public static final int TYPE123_SYNTAX_EXPR_AS_CONDITION_MISSING = 4195092;
    public static final int TYPE123_SYNTAX_EXPR_AS_FORSEQ_MISSING = 4195093;
    public static final int TYPE123_SYNTAX_EXPR_AS_BODY_MISSING = 4195094;
    public static final int TYPE123_SYNTAX_EXPR_IN_GROUP_MISSING = 4195095;
    public static final int TYPE123_SYNTAX_EXPR_AS_ARGVALUE_MISSING = 4195096;
    public static final int TYPE12_SYNTAX_ELEMENTNAME_MISSING = 4195104;
    public static final int TYPE12_SYNTAX_SYMBOL_MISSING = 0x400330;
    public static final int TYPE12_SYNTAX_OPERATOR_MISSING = 4195200;
    public static final int TYPE12_SYNTAX_FCALL_AFTER_OP_MISSING = 4195248;
    public static final int TYPE1_SYNTAX_INCOMPLETE_NODE = 1024;
    public static final int TYPE12_SYNTAX_NODE_NOT_CLOSED = 0x400410;
    public static final int TYPE1_SYNTAX_INCOMPLETE_CC = 1280;
    public static final int TYPE12_SYNTAX_CC_NOT_CLOSED = 4195600;
    public static final int TYPE12_SYNTAX_IF_MISSING = 4195632;
    public static final int TYPE12_SYNTAX_CONDITION_MISSING = 0x400540;
    public static final int TYPE12_SYNTAX_IN_MISSING = 0x400550;
    public static final int TYPE12_SYNTAX_CONDITION_NOT_CLOSED = 4195680;
    public static final int TYPE1_SYNTAX_INCOMPLETE_FDEF = 1536;
    public static final int TYPE12_SYNTAX_FDEF_ARGS_MISSING = 4195856;
    public static final int TYPE12_SYNTAX_FDEF_ARGS_NOT_CLOSED = 4195872;
    public static final int TYPE1_SYNTAX_INCOMPATIBLE = 1792;
    public static final int TYPE12_SYNTAX_UNSUPPORTED_IN_LANG_VERSION = 4196112;
    public static final int TYPE12_SYNTAX_OPTIONAL_IN_LANG_VERSION = 1824;
    public static final int CTX12_IF = 4096;
    public static final int CTX12_ELSE = 8192;
    public static final int CTX12_FOR = 12288;
    public static final int CTX12_WHILE = 16384;
    public static final int CTX12_REPEAT = 20480;
    public static final int CTX12_FDEF = 24576;
    public static final int CTX12_FCALL = 28672;
    public static final int CTX12_PIPE = 32768;

    public static Version getSuitableLangVersion(Version version) {
        if (version.compareTo(LANG_VERSION_4_4) >= 0) {
            return LANG_VERSION_4_4;
        }
        if (version.compareTo(LANG_VERSION_4_3) >= 0) {
            return LANG_VERSION_4_3;
        }
        if (version.compareTo(LANG_VERSION_4_2) >= 0) {
            return LANG_VERSION_4_2;
        }
        if (version.compareTo(LANG_VERSION_4_1) >= 0) {
            return LANG_VERSION_4_1;
        }
        return LANG_VERSION_4_0;
    }

    public static ImList<Version> getLangVersionsSince(Version version) {
        int first = LANG_VERSIONS.indexOf(ObjectUtils.nonNullAssert((Object)version));
        if (first == -1) {
            throw new IllegalArgumentException("version= " + String.valueOf(version));
        }
        return LANG_VERSIONS.subList(0, first + 1);
    }

    public static ImList<Version> getLangVersionsBefore(Version version) {
        int first = LANG_VERSIONS.indexOf(ObjectUtils.nonNullAssert((Object)version));
        if (first == -1) {
            throw new IllegalArgumentException("version= " + String.valueOf(version));
        }
        return LANG_VERSIONS.subList(first + 1, LANG_VERSIONS.size());
    }
}

