/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.util.SourceMessageUtil;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.QuickRefactoring;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RModelUtils;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.refactoring.RSourceCodeModifyUtil;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class IfNotNullElseToSpecialRefactoring
extends QuickRefactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private final RSourceUnit sourceUnit;
    private final CIfElse sourceNode;
    private @Nullable RAstNode primaryNode;
    private @Nullable RAstNode elseNode;

    public IfNotNullElseToSpecialRefactoring(RSourceUnit su, CIfElse sourceNode) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        this.sourceNode = sourceNode;
    }

    public String getBundleId() {
        return "org.eclipse.statet.r.core";
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ConvertIfNotNullElseToSpecialOperation";
    }

    public String getName() {
        return Messages.IfNotNullElseToSpecial_label;
    }

    public RefactoringStatus checkInitialConditions(@Nullable IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            FCall fCall;
            RCoreAccess rCoreAccess = RCore.getContextAccess((IAdaptable)this.sourceUnit);
            CIfElse sourceNode = this.sourceNode;
            RAstNode condNode = sourceNode.getCondChild();
            boolean not = false;
            if (condNode.getNodeType() == NodeType.NOT) {
                not = true;
                condNode = condNode.getChild(0);
            }
            if (condNode.getNodeType() == NodeType.F_CALL && RModelUtils.matches(fCall = (FCall)condNode, RCoreFunctions.BASE_IsNull_ELEMENT_NAME) && sourceNode.hasElse()) {
                RAstNode elseNode;
                RAstNode matchNode;
                RAstNode primaryNode = RAsts.matchArgs(fCall, RCoreFunctions.getDefinitions((RSourceConfig)rCoreAccess.getRSourceConfig()).BASE_IsNull_fSpec).getArgValueNode(0);
                if (not) {
                    matchNode = sourceNode.getThenChild();
                    elseNode = sourceNode.getElseChild();
                } else {
                    matchNode = sourceNode.getElseChild();
                    elseNode = sourceNode.getThenChild();
                }
                if (primaryNode != null && (primaryNode.equalsValue(matchNode) || matchNode.getNodeType() == NodeType.BLOCK && matchNode.getChildCount() == 1 && primaryNode.equalsValue(matchNode.getChild(0)))) {
                    if (elseNode.getNodeType() == NodeType.BLOCK && elseNode.getChildCount() == 1) {
                        elseNode = elseNode.getChild(0);
                    }
                    this.primaryNode = primaryNode;
                    this.elseNode = elseNode;
                }
            }
            if (this.primaryNode == null || this.elseNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"Cannot convert the statement.");
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = new RefactoringStatus();
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges(textFileChange, m.newChild(2));
            textFileChange.setInsertPosition(new Position(this.sourceNode.getStartOffset(), 0));
            HashMap arguments = new HashMap();
            SourceMessageUtil messageUtil = new SourceMessageUtil(this.sourceUnit.getContent((IProgressMonitor)m));
            String description = NLS.bind((String)Messages.IfNotNullElseToSpecial_Descriptor_description, (Object)messageUtil.getFullQuoteText((AstNode)this.primaryNode));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, this.getName(), new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    public SourceUnitChange createTextChange(SubMonitor m) throws CoreException {
        m.setWorkRemaining(2);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            this.createChanges(textFileChange, m.newChild(2));
            return textFileChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
    }

    private void createChanges(SourceUnitChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(7);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            RSourceCodeModifyUtil util = new RSourceCodeModifyUtil(this.adapter, this.sourceUnit, m.newChild(1));
            CIfElse sourceNode = this.sourceNode;
            RAstNode primaryNode = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.primaryNode)));
            RAstNode elseNode = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.elseNode)));
            int changeStart = sourceNode.getStartOffset();
            int changeEnd = sourceNode.getEndOffset();
            util.clear();
            util.append(primaryNode, primaryNode.getNodeType().opPrec > NodeType.SPECIAL.opPrec);
            util.appendOperator("%||%");
            util.append(elseNode, elseNode.getNodeType().opPrec >= NodeType.SPECIAL.opPrec && (elseNode.getNodeType() != NodeType.SPECIAL || elseNode.getText() != "||"));
            RAstNode parentNode = sourceNode.getRParent();
            if (parentNode != null && parentNode.getNodeType().opPrec <= NodeType.SPECIAL.opPrec && (parentNode.getNodeType() != NodeType.SPECIAL || parentNode.getText() != "||")) {
                util.insert(0, '(');
                util.append(')');
            }
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.IfNotNullElse_Changes_name, (TextEdit)util.createReplaceEdit(changeStart, changeEnd));
            m.worked(4);
            TextChangeCompatibility.addMarker((TextChange)change, (RangeMarker)new RangeMarker(changeEnd, 0));
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }
}

