/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui;

import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.r.console.ui.page.RConsolePage;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.Version;
import org.eclipse.statet.nico.core.NicoCore;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleColorAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.RSourceConstants;
import org.eclipse.statet.r.launching.ui.RErrorLineTracker;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.part.IPageBookViewPage;

@NonNullByDefault
public class RConsole
extends NIConsole
implements RCoreAccess {
    private final PreferenceAccess prefs;
    private @Nullable RSourceConfig rSourceConfig;

    public RConsole(RProcess process, NIConsoleColorAdapter adapter) {
        super((ToolProcess)process, adapter);
        RErrorLineTracker lineMatcher = new RErrorLineTracker((ToolProcess)process);
        this.addPatternMatchListener((IPatternMatchListener)lineMatcher);
        this.prefs = NicoCore.getInstanceConsolePreferences();
    }

    public RProcess getProcess() {
        return (RProcess)super.getProcess();
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new RConsolePage(this, view);
    }

    protected String getSymbolicFontName() {
        return "org.eclipse.statet.workbench.themes.ConsoleFont";
    }

    public PreferenceAccess getPrefs() {
        return this.prefs;
    }

    public REnv getREnv() {
        return this.getProcess().getREnv();
    }

    public RSourceConfig getRSourceConfig() {
        RSourceConfig rSourceConfig = this.rSourceConfig;
        if (rSourceConfig == null) {
            RPlatform platform;
            ToolController controller = this.getProcess().getController();
            if (controller instanceof RService && (platform = ((RService)controller).getPlatform()) != null) {
                this.rSourceConfig = rSourceConfig = new RSourceConfig(RSourceConstants.getSuitableLangVersion((Version)platform.getRVersion()));
            }
            if (rSourceConfig == null) {
                rSourceConfig = RSourceConfig.DEFAULT_CONFIG;
            }
        }
        return rSourceConfig;
    }

    public RCodeStyleSettings getRCodeStyle() {
        return RCore.getWorkbenchAccess().getRCodeStyle();
    }
}

