/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.eclipse.statet.internal.jcommons.collections.ArrayUtils;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class CopyOnWriteIdentityListSet<E>
extends AbstractSet<E>
implements IdentitySet<E> {
    private volatile ImIdentityList<E> list;

    private static int indexOf(Object[] array, int end, @Nullable Object e) {
        int i = 0;
        while (i < end) {
            if (e == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CopyOnWriteIdentityListSet() {
        this.list = ImCollections.newIdentityList();
    }

    public CopyOnWriteIdentityListSet(Set<? extends E> initialSet) {
        this.list = ImCollections.toIdentityList(initialSet);
    }

    @Override
    public synchronized boolean add(E e) {
        if (!this.list.contains(e)) {
            this.list = ImCollections.addElement(this.list, e);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(@Nullable Object e) {
        ImIdentityList<E> l = ImCollections.removeElement(this.list, e);
        if (l != this.list) {
            this.list = l;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty() || this.list.containsAll(c)) {
            return false;
        }
        ImIdentityList<E> l = this.list;
        Object[] toAdd = c.toArray();
        int end = toAdd.length;
        int i = 0;
        while (i < end) {
            if (l.contains(toAdd[i]) || CopyOnWriteIdentityListSet.indexOf(toAdd, i, toAdd[i]) >= 0) {
                System.arraycopy(toAdd, i + 1, toAdd, i, end - i - 1);
                --end;
                continue;
            }
            ++i;
        }
        if (end > 0) {
            this.list = ImCollections.concatList(l, ImCollections.newIdentityList(toAdd, 0, end));
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        Object[] array = this.list.toArray();
        Object[] toRetain = c.toArray();
        int end = array.length;
        int i = 0;
        while (i < end) {
            if (CopyOnWriteIdentityListSet.indexOf(toRetain, toRetain.length, array[i]) >= 0) {
                ++i;
                continue;
            }
            System.arraycopy(array, i + 1, array, i, end - i - 1);
            --end;
        }
        if (end < array.length) {
            this.list = ImCollections.newIdentityList(array, 0, end);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        Iterator<?> iter = c.iterator();
        int idx = -1;
        do {
            if (!iter.hasNext()) {
                return false;
            }
            idx = this.list.indexOf(iter.next());
        } while (idx == -1);
        int n = this.list.size() - 1;
        if (n == 0) {
            this.list = ImCollections.emptyIdentityList();
            return true;
        }
        Object[] a = ArrayUtils.copyRemoveElement(this.list, n, idx);
        while (iter.hasNext()) {
            idx = CopyOnWriteIdentityListSet.indexOf(a, n, iter.next());
            if (idx < 0) continue;
            System.arraycopy(a, idx + 1, a, idx, n - idx - 1);
            --n;
        }
        this.list = ImCollections.newIdentityList(a, 0, n);
        return true;
    }

    @Override
    public synchronized void clear() {
        if (!this.list.isEmpty()) {
            this.list = ImCollections.newIdentityList();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return this.list.contains(e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public ImIdentityList<E> toList() {
        return this.list;
    }

    public synchronized ImIdentityList<E> clearToList() {
        ImIdentityList<E> list = this.list;
        if (!list.isEmpty()) {
            this.list = ImCollections.newIdentityList();
        }
        return list;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Set) {
            Set other = (Set)obj;
            ImIdentityList<E> l = this.list;
            return l.size() == other.size() && l.containsAll(other);
        }
        return false;
    }
}

