/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.data.ControlData;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BasicLayerCell
implements LayerCell {
    private static final ControlData NO_DATA = new ControlData(0, "");
    private final Layer layer;
    private final LayerCellDim h;
    private final LayerCellDim v;

    public BasicLayerCell(Layer layer, LayerCellDim horizontalDim, LayerCellDim verticalDim) {
        this.layer = layer;
        this.h = horizontalDim;
        this.v = verticalDim;
    }

    @Override
    public final Layer getLayer() {
        return this.layer;
    }

    @Override
    public final LayerCellDim getDim(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return this.h;
            }
            case VERTICAL: {
                return this.v;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final long getColumnPosition() {
        return this.h.getPosition();
    }

    @Override
    public final long getRowPosition() {
        return this.v.getPosition();
    }

    @Override
    public final long getOriginColumnPosition() {
        return this.h.getOriginPosition();
    }

    @Override
    public final long getOriginRowPosition() {
        return this.v.getOriginPosition();
    }

    @Override
    public final long getColumnSpan() {
        return this.h.getPositionSpan();
    }

    @Override
    public final long getRowSpan() {
        return this.v.getPositionSpan();
    }

    @Override
    public final boolean isSpannedCell() {
        return this.getColumnSpan() > 1L || this.getRowSpan() > 1L;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return DisplayMode.NORMAL;
    }

    @Override
    public LabelStack getLabels() {
        return new LabelStack();
    }

    @Override
    public @Nullable Object getDataValue(int flags, @Nullable IProgressMonitor monitor) {
        return NO_DATA;
    }

    @Override
    public LRectangle getBounds() {
        LayerCellDim dim = this.getDim(Orientation.HORIZONTAL);
        long cellPosition = dim.getPosition();
        long firstPosition = dim.getOriginPosition();
        long lastPosition = firstPosition + dim.getPositionSpan() - 1L;
        LayerDim layerDim = this.getLayer().getDim(Orientation.HORIZONTAL);
        long xOffset = layerDim.getPositionStart(cellPosition, firstPosition);
        long width = firstPosition == lastPosition ? (long)layerDim.getPositionSize(cellPosition, lastPosition) : layerDim.getPositionStart(cellPosition, lastPosition) - xOffset + (long)layerDim.getPositionSize(cellPosition, lastPosition);
        dim = this.getDim(Orientation.VERTICAL);
        cellPosition = dim.getPosition();
        firstPosition = dim.getOriginPosition();
        lastPosition = firstPosition + dim.getPositionSpan() - 1L;
        layerDim = this.getLayer().getDim(Orientation.VERTICAL);
        long yOffset = layerDim.getPositionStart(cellPosition, firstPosition);
        long height = firstPosition == lastPosition ? (long)layerDim.getPositionSize(cellPosition, lastPosition) : layerDim.getPositionStart(cellPosition, lastPosition) - yOffset + (long)layerDim.getPositionSize(cellPosition, lastPosition);
        return new LRectangle(xOffset, yOffset, width, height);
    }

    public int hashCode() {
        int h = this.h.hashCode() + this.v.hashCode();
        return h ^ h * this.getLayer().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LayerCell) {
            LayerCell other = (LayerCell)obj;
            return this.layer.equals(other.getLayer()) && this.h.equals(other.getDim(Orientation.HORIZONTAL)) && this.v.equals(other.getDim(Orientation.VERTICAL));
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (\n\tdata= " + String.valueOf(this.getDataValue(0, null)) + "\n\tlayer= " + this.getLayer().getClass().getSimpleName() + "\n\thorizontal= " + String.valueOf(this.h) + "\n\tvertical= " + String.valueOf(this.v) + "\n)";
    }
}

