/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.swt.AccessibleArrowImage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class WaCombo
extends Composite {
    private static final int[] COMBO_EVENTS = new int[]{12, 15, 10, 11};
    private static final int[] TEXT_EVENTS = new int[]{1, 2, 35, 6, 7, 5, 3, 4, 8, 32, 37, 29, 31, 15, 25};
    private static final int[] ARROW_EVENTS = new int[]{29, 6, 7, 5, 3, 4, 37, 32, 13, 15};
    private Label fImage;
    private Label fText;
    private Button fArrow;
    private Shell fPopupParent;
    private Shell fPopup;
    private boolean fHasFocus;
    private Listener fListener;
    private Listener fFilter;
    private Color fForeground;
    private Color fBackground;
    private Font fFont;
    private Table fList;
    private int fItemCount;
    private int fVisibleItemCount;
    private int fArrowImageSize;

    private static int checkStyle(int style) {
        int mask = 0x6800800;
        return 0x80008 | style & 0x6800800;
    }

    public WaCombo(Composite parent, int style) {
        int itemHeight;
        int arrowStyle;
        style = WaCombo.checkStyle(style);
        super(parent, style);
        this.fItemCount = 0;
        this.fVisibleItemCount = 10;
        this.setBackgroundMode(2);
        this.fPopupParent = super.getShell();
        this.fImage = new Label((Composite)this, 0x1000000);
        int textStyle = 4;
        this.fText = new Label((Composite)this, 4);
        boolean system = !Platform.getWS().equals("win32");
        int n = arrowStyle = system ? 1028 : 8;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.fArrow = new Button((Composite)this, arrowStyle);
        if (!system) {
            this.updateImage(-1);
        }
        this.fListener = new Listener(){

            public void handleEvent(Event event) {
                if (WaCombo.this.isDisposed()) {
                    return;
                }
                if (WaCombo.this.fPopup == event.widget) {
                    WaCombo.this.popupEvent(event);
                    return;
                }
                if (WaCombo.this.fImage == event.widget || WaCombo.this.fText == event.widget) {
                    WaCombo.this.textEvent(event);
                    return;
                }
                if (WaCombo.this.fList == event.widget) {
                    WaCombo.this.listEvent(event);
                    return;
                }
                if (WaCombo.this.fArrow == event.widget) {
                    WaCombo.this.arrowEvent(event);
                    return;
                }
                if (WaCombo.this == event.widget) {
                    WaCombo.this.comboEvent(event);
                    return;
                }
                if (WaCombo.this.getShell() == event.widget) {
                    WaCombo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (WaCombo.this.isDisposed()) {
                                return;
                            }
                            WaCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.fFilter = new Listener(){

            public void handleEvent(Event event) {
                if (WaCombo.this.isDisposed()) {
                    return;
                }
                if (event.type == 13) {
                    if (event.widget instanceof ScrollBar) {
                        WaCombo.this.handleScroll(event);
                    }
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == WaCombo.this.getShell()) {
                    WaCombo.this.handleFocus(16);
                }
            }
        };
        int i = 0;
        while (i < COMBO_EVENTS.length) {
            this.addListener(COMBO_EVENTS[i], this.fListener);
            ++i;
        }
        i = 0;
        while (i < TEXT_EVENTS.length) {
            this.fImage.addListener(TEXT_EVENTS[i], this.fListener);
            ++i;
        }
        i = 0;
        while (i < TEXT_EVENTS.length) {
            this.fText.addListener(TEXT_EVENTS[i], this.fListener);
            ++i;
        }
        i = 0;
        while (i < ARROW_EVENTS.length) {
            this.fArrow.addListener(ARROW_EVENTS[i], this.fListener);
            ++i;
        }
        this.createPopup(-1);
        if ((style & 0x40) == 0 && (itemHeight = this.fList.getItemHeight()) != 0) {
            int maxHeight = this.getMonitor().getClientArea().height / 3;
            this.fVisibleItemCount = Math.max(this.fVisibleItemCount, maxHeight / itemHeight);
        }
        this.initAccessible();
    }

    private void checkShell() {
        if (this.getShell() != this.fPopup.getParent()) {
            if (this.fPopup.setParent((Composite)this.getShell())) {
                return;
            }
            int selectionIndex = this.fList.getSelectionIndex();
            this.fList.removeListener(12, this.fListener);
            this.fPopup.dispose();
            this.fPopup = null;
            this.fList = null;
            this.createPopup(selectionIndex);
        }
    }

    private void updateImage(int size) {
        if (size == -1) {
            size = 5;
        }
        this.fArrowImageSize = size;
        Image image = SharedUIResources.getInstance().getImageDescriptorRegistry().get((ImageDescriptor)new AccessibleArrowImage(1024, size, this.fArrow.getForeground().getRGB(), this.fArrow.getBackground().getRGB()));
        this.fArrow.setImage(image);
    }

    private void createPopup(int selectionIndex) {
        this.fPopup = new Shell(this.getShell(), 16392);
        int style = this.getStyle();
        int listStyle = 66052;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        this.fList = new Table((Composite)this.fPopup, listStyle);
        if (this.fFont != null) {
            this.fList.setFont(this.fFont);
        }
        if (this.fForeground != null) {
            this.fList.setForeground(this.fForeground);
        }
        if (this.fBackground != null) {
            this.fList.setBackground(this.fBackground);
        }
        int[] popupEvents = new int[]{21, 9};
        int i = 0;
        while (i < popupEvents.length) {
            this.fPopup.addListener(popupEvents[i], this.fListener);
            ++i;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 16, 12};
        int i2 = 0;
        while (i2 < listEvents.length) {
            this.fList.addListener(listEvents[i2], this.fListener);
            ++i2;
        }
        this.fList.setItemCount(this.fItemCount);
        if (selectionIndex != -1) {
            this.fList.setSelection(selectionIndex);
        }
    }

    void dropDown(boolean drop) {
        int y;
        if (drop == this.isDropped()) {
            return;
        }
        Display display = this.getDisplay();
        if (!drop) {
            display.removeFilter(13, this.fFilter);
            this.fPopup.setVisible(false);
            if (!this.isDisposed() && this.isFocusControl()) {
                this.fArrow.setFocus();
            }
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        this.checkShell();
        Point comboSize = this.getSize();
        int itemCount = this.fList.getItemCount();
        itemCount = itemCount == 0 ? this.fVisibleItemCount : Math.min(this.fVisibleItemCount, itemCount);
        int itemHeight = this.fList.getItemHeight() * itemCount;
        Point listSize = this.fList.computeSize(24 + this.getMaxListTextWidth(), itemHeight, true);
        Rectangle displayRect = this.getMonitor().getClientArea();
        this.fList.setBounds(1, 1, Math.max(comboSize.x - 2, Math.min(listSize.x, displayRect.width - 2)), listSize.y);
        int index = this.fList.getSelectionIndex();
        if (index != -1) {
            this.fList.setTopIndex(index);
        }
        Rectangle listRect = this.fList.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        int width = listRect.width + 2;
        int height = listRect.height + 2;
        int x = parentRect.x;
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - width;
        }
        if ((y = parentRect.y + comboSize.y) + height > displayRect.y + displayRect.height) {
            int popDownwardsHeight;
            int popUpwardsHeight = parentRect.y - height < displayRect.y ? parentRect.y - displayRect.y : height;
            if (popUpwardsHeight > (popDownwardsHeight = displayRect.y + displayRect.height - y)) {
                height = popUpwardsHeight;
                y = parentRect.y - popUpwardsHeight;
            } else {
                height = popDownwardsHeight;
            }
            this.fList.setSize(listRect.width, height - 2);
        }
        this.fPopup.setBounds(x, y, width, height);
        if (this.fList.getColumnCount() == 0) {
            new TableColumn(this.fList, 16384);
        }
        this.fList.getColumn(0).setWidth(this.fList.getClientArea().width);
        this.fPopup.setVisible(true);
        if (this.isFocusControl()) {
            this.fList.setFocus();
        }
        display.removeFilter(13, this.fFilter);
        display.addFilter(13, this.fFilter);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.fText.isFocusControl() || this.fArrow.isFocusControl() || this.fList.isFocusControl() || this.fPopup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.fItemCount;
    }

    public void setItemCount(int count) {
        this.fItemCount = count;
        if (this.fList != null) {
            this.fList.setItemCount(count);
        }
    }

    public Item[] getItems() {
        this.checkWidget();
        return this.fList.getItems();
    }

    public Item getItem(int index) {
        this.checkWidget();
        return this.fList.getItem(index);
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fList.getItemHeight();
    }

    public Shell getShell() {
        this.checkWidget();
        Shell shell = super.getShell();
        if (shell != this.fPopupParent) {
            if (this.fPopupParent != null && !this.fPopupParent.isDisposed()) {
                this.fPopupParent.removeListener(27, this.fListener);
            }
            this.fPopupParent = shell;
        }
        return this.fPopupParent;
    }

    public int getStyle() {
        int style = super.getStyle();
        return style |= 8;
    }

    void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.fHasFocus) {
                    return;
                }
                this.fHasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.fListener);
                shell.addListener(27, this.fListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.fFilter);
                display.addFilter(15, this.fFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.fHasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.fArrow || focusControl == this.fList || focusControl == this.fText) {
                    return;
                }
                this.fHasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.fListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.fFilter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    void handleScroll(Event event) {
        ScrollBar scrollBar = (ScrollBar)event.widget;
        Scrollable scrollableParent = scrollBar.getParent();
        if (scrollableParent.equals(this.fList)) {
            return;
        }
        if (this.isParentScrolling((Control)scrollableParent)) {
            this.dropDown(false);
        }
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                String text = WaCombo.this.getAssociatedLabel();
                if (text != null) {
                    name = WaCombo.this.stripMnemonic(text);
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String shortcut = null;
                String text = WaCombo.this.getAssociatedLabel();
                if (text != null && (mnemonic = WaCombo.this.findMnemonicChar(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = WaCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.fText.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.fList.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.fArrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = WaCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = WaCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = WaCombo.this.toControl(e.x, e.y);
                if (WaCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = WaCombo.this.getBounds();
                Point pt = WaCombo.this.getParent().toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = WaCombo.this.fText.getText();
            }
        });
        this.fText.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }
        });
        this.fArrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = WaCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.fPopup.getVisible();
    }

    boolean isParentScrolling(Control scrollableParent) {
        Composite parent = this.getParent();
        while (parent != null) {
            if (parent.equals(scrollableParent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private int getMaxListTextWidth() {
        GC gc = new GC((Drawable)this.fText);
        try {
            int textWidth = gc.stringExtent((String)this.fText.getText()).x;
            TableItem[] items = this.fList.getItems();
            int i = 0;
            while (i < items.length) {
                textWidth = Math.max(gc.stringExtent((String)items[i].getText()).x, textWidth);
                ++i;
            }
            int n = textWidth;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point imageSize = this.fImage.computeSize(16, 16, changed);
        imageSize.x += 5;
        imageSize.y += 2;
        Point textSize = this.fText.computeSize(-1, -1, changed);
        textSize.y += 2;
        Point arrowSize = this.fArrow.computeSize(20, 16, changed);
        int textWidth = this.getMaxListTextWidth();
        int borderWidth = this.getBorderWidth();
        if (imageSize.y > height) {
            height = imageSize.y;
        }
        if (textSize.y > height) {
            height = textSize.y;
        }
        int spacer = 2;
        width = imageSize.x + textWidth + 4 + arrowSize.x + 2 * borderWidth;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    private void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point imageSize = this.fImage.computeSize(16, 16, changed);
        imageSize.x += 5;
        if (this.fArrowImageSize > 0) {
            int bestSize = 5;
            if (height <= 20) {
                --bestSize;
            } else if (height > 30) {
                ++bestSize;
            }
            if (this.fArrowImageSize != bestSize) {
                this.updateImage(bestSize);
            }
        }
        Point arrowSize = this.fArrow.computeSize(19, height, changed);
        this.fImage.setBounds(0, 0, imageSize.x, height);
        this.fText.setBounds(imageSize.x, 1, width - imageSize.x - arrowSize.x, height);
        this.fArrow.setBounds(width - arrowSize.x + 1, -1, arrowSize.x, height + 2);
    }

    public void redraw() {
        super.redraw();
        this.fText.redraw();
        this.fArrow.redraw();
        if (this.fPopup.isVisible()) {
            this.fList.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(25, (Listener)typedListener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(25, (SWTEventListener)listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fImage != null) {
            this.fImage.setEnabled(enabled);
        }
        if (this.fText != null) {
            this.fText.setEnabled(enabled);
        }
        if (this.fArrow != null) {
            this.fArrow.setEnabled(enabled);
        }
        if (this.fPopup != null) {
            this.fPopup.setVisible(false);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.getVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        return this.fArrow.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fList.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.fForeground = color;
        if (this.fImage != null) {
            this.fImage.setForeground(color);
        }
        if (this.fText != null) {
            this.fText.setForeground(color);
        }
        if (this.fList != null) {
            this.fList.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.fBackground = color;
    }

    public void setMenu(Menu menu) {
        this.fImage.setMenu(menu);
        this.fText.setMenu(menu);
    }

    public Menu getMenu() {
        return this.fText.getMenu();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.fImage.setToolTipText(string);
        this.fArrow.setToolTipText(string);
        this.fText.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (this.fPopup == null || this.fPopup.isDisposed()) {
            return;
        }
        if (!visible) {
            this.fPopup.setVisible(false);
        }
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.fVisibleItemCount;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.fVisibleItemCount = count;
    }

    public Table getList() {
        return this.fList;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.isDropped();
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        this.dropDown(visible);
    }

    private String getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this) {
                if (i <= 0) break;
                Control sibling = siblings[i - 1];
                if (sibling instanceof Label) {
                    return ((Label)sibling).getText();
                }
                if (!(sibling instanceof CLabel)) break;
                return ((CLabel)sibling).getText();
            }
            ++i;
        }
        return null;
    }

    private char findMnemonicChar(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    private String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return string.substring(0, index - 1) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    private void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.removeListener(12, this.fListener);
                this.notifyListeners(12, event);
                event.type = 0;
                if (this.fPopup != null && !this.fPopup.isDisposed()) {
                    this.fList.removeListener(12, this.fListener);
                    this.fPopup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.fListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.fFilter);
                this.fPopup = null;
                this.fText = null;
                this.fList = null;
                this.fArrow = null;
                this.fPopupParent = null;
                break;
            }
            case 15: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.fArrow || focusControl == this.fList) {
                    return;
                }
                if (this.isDropped()) {
                    this.fList.setFocus();
                    break;
                }
                this.fArrow.setFocus();
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    private void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 32: {
                Point pt = this.getDisplay().map((Control)this.fArrow, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(event.type, event);
                event.type = 0;
                break;
            }
            case 37: {
                Point pt = this.getDisplay().map((Control)this.fArrow, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(37, event);
                event.type = 0;
                if (this.isDisposed() || !event.doit || event.count == 0) break;
                event.doit = false;
                int oldIndex = this.getSelectionIndex();
                if (event.count > 0) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 13: {
                this.fArrow.setFocus();
                this.dropDown(!this.isDropped());
            }
        }
    }

    private void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 14: {
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                this.notifyListeners(14, e);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: 
            case 32: {
                Point pt = this.getDisplay().map((Control)event.widget, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(event.type, event);
                event.type = 0;
                break;
            }
            case 1: {
                Event keyEvent = new Event();
                keyEvent.time = event.time;
                keyEvent.character = event.character;
                keyEvent.keyCode = event.keyCode;
                keyEvent.keyLocation = event.keyLocation;
                keyEvent.stateMask = event.stateMask;
                this.notifyListeners(1, keyEvent);
                if (this.isDisposed()) break;
                event.doit = keyEvent.doit;
                if (!event.doit || event.keyCode != 0x1000001 && event.keyCode != 0x1000002) break;
                event.doit = false;
                if ((event.stateMask & 0x10000) != 0) {
                    boolean dropped = this.isDropped();
                    if (!dropped) {
                        this.setFocus();
                    }
                    this.dropDown(!dropped);
                    break;
                }
                int oldIndex = this.getSelectionIndex();
                if (event.keyCode == 0x1000001) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 35: {
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.x = event.x;
                e.y = event.y;
                this.notifyListeners(35, e);
                event.doit = e.doit;
                event.x = e.x;
                event.y = e.y;
                break;
            }
            case 24: {
                this.fList.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                Point pt = this.getDisplay().map((Control)event.widget, (Control)this, event.x, event.y);
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = pt.x;
                mouseEvent.y = pt.y;
                this.notifyListeners(3, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                boolean dropped = this.isDropped();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                Point pt = this.getDisplay().map((Control)event.widget, (Control)this, event.x, event.y);
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = pt.x;
                mouseEvent.y = pt.y;
                this.notifyListeners(4, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit || event.button == 1) break;
                return;
            }
            case 37: {
                this.notifyListeners(37, event);
                event.type = 0;
                if (this.isDisposed() || !event.doit || event.count == 0) break;
                event.doit = false;
                int oldIndex = this.getSelectionIndex();
                if (event.count > 0) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: {
                        event.doit = this.traverse(8);
                        event.detail = 0;
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 25: {
                Event e = new Event();
                e.text = event.text;
                e.start = event.start;
                e.end = event.end;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                e.stateMask = event.stateMask;
                this.notifyListeners(25, e);
                event.text = e.text;
                event.doit = e.doit;
            }
        }
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.fList.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
            }
        }
    }

    private void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.checkShell();
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 16: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.getSize();
                    Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                    if (rect.contains(point)) {
                        boolean comboShellActivated;
                        boolean bl = comboShellActivated = this.getDisplay().getActiveShell() == this.getShell();
                        if (comboShellActivated) break;
                        this.dropDown(false);
                        break;
                    }
                }
                this.dropDown(false);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.fList.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.updateText(this.fList.getItem(index));
                this.fList.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = this.fText.traverse(event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDown(false);
                        }
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.keyLocation = event.keyLocation;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                event.doit = e.doit;
            }
        }
    }

    void updateText(TableItem item) {
        if (item == null) {
            this.fImage.setImage(null);
            this.fText.setText("");
            return;
        }
        this.fImage.setImage(item.getImage());
        this.fText.setText(item.getText());
        this.fText.setFont(item.getFont());
    }

    public boolean traverse(int event) {
        if (event == 64 || event == 16) {
            return this.fArrow.traverse(event);
        }
        return super.traverse(event);
    }

    public int indexOf(Item item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        return this.fList.indexOf((TableItem)item);
    }

    public void remove(int index) {
        this.checkWidget();
        this.fList.remove(index);
        this.fItemCount = this.fList.getItemCount();
    }

    public void removeAll() {
        this.checkWidget();
        this.fText.setText("");
        this.fList.removeAll();
        this.fItemCount = this.fList.getItemCount();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.fList.getSelectionIndex();
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.fList.deselectAll();
            this.fText.setText("");
            return;
        }
        if (index >= 0 && index < this.fList.getItemCount() && index != this.getSelectionIndex()) {
            this.updateText(this.fList.getItem(index));
            this.fList.select(index);
            this.fList.showSelection();
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.fList.getItemCount() && index == this.fList.getSelectionIndex()) {
            this.updateText(null);
            this.fList.deselect(index);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.updateText(null);
        this.fList.deselectAll();
    }
}

