/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.OverlayStatus;

public class CombineStatusChangeListener
implements StatusChangeListener {
    private final StatusChangeListener fParent;
    private IStatus fBaseStatus = Status.OK_STATUS;
    private final List<StackListeners> fStack = new ArrayList<StackListeners>();

    public CombineStatusChangeListener(StatusChangeListener statusListener) {
        this.fParent = statusListener;
    }

    public void statusChanged(IStatus status) {
        this.fBaseStatus = status;
        this.update();
    }

    private void update() {
        if (this.fStack.isEmpty()) {
            this.fParent.statusChanged(this.fBaseStatus);
            return;
        }
        int severity = 0;
        int i = 0;
        while (i < this.fStack.size()) {
            int s2 = this.fStack.get((int)i).status.getSeverity();
            if (s2 > severity) {
                severity = s2;
            }
            ++i;
        }
        System.out.println(severity);
        this.fParent.statusChanged((IStatus)new OverlayStatus(this.fStack.get((int)(this.fStack.size() - 1)).status, severity));
    }

    public StatusChangeListener newListener() {
        StackListeners listener = new StackListeners();
        this.fStack.add(listener);
        return listener;
    }

    public void removeListener(StatusChangeListener listener) {
        this.fStack.remove(listener);
        this.update();
    }

    private class StackListeners
    implements StatusChangeListener {
        private IStatus status = Status.OK_STATUS;

        private StackListeners() {
        }

        public void statusChanged(IStatus status) {
            this.status = status;
            CombineStatusChangeListener.this.update();
        }
    }
}

