/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.ui.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class FieldNameTextStyleScanner
implements ITokenScanner {
    private final TextStyleManager<?> textStyles;
    private final TextStyleManager.TextStyleToken<?> keyToken;
    private final TextStyleManager.TextStyleToken<?> separatorToken;
    private IDocument document;
    private int parseStartOffset;
    private int parseEndOffset;
    private int separatorOffset;
    private int currentOffset;
    private int currentLength;

    public FieldNameTextStyleScanner(TextStyleManager<?> textStyles) {
        this.textStyles = textStyles;
        this.keyToken = this.getToken("dsl_ts_Key");
        this.separatorToken = this.getToken("dsl_ts_Indicator");
    }

    protected TextStyleManager.TextStyleToken<?> getToken(String key) {
        return this.textStyles.getToken(key);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.parseStartOffset = offset;
        this.parseEndOffset = offset + length;
        this.separatorOffset = Integer.MIN_VALUE;
        this.currentOffset = offset;
        this.currentLength = 0;
    }

    public IToken nextToken() {
        int currentOffset = this.currentOffset += this.currentLength;
        this.currentLength = 0;
        if (currentOffset >= this.parseEndOffset) {
            return Token.EOF;
        }
        int separatorOffset = this.checkSeparator();
        if (separatorOffset == currentOffset) {
            this.currentLength = 1;
            return this.separatorToken;
        }
        this.currentLength = (separatorOffset > currentOffset ? separatorOffset : this.parseEndOffset) - this.currentOffset;
        return this.keyToken;
    }

    public int getTokenOffset() {
        return this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }

    private int checkSeparator() {
        int separatorOffset = this.separatorOffset;
        if (separatorOffset == Integer.MIN_VALUE) {
            separatorOffset = -1;
            try {
                if (this.parseStartOffset < this.parseEndOffset && this.document.getChar(this.parseEndOffset - 1) == ':') {
                    separatorOffset = this.parseEndOffset - 1;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.separatorOffset = separatorOffset;
        }
        return separatorOffset;
    }
}

