/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigMainTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.ecommons.databinding.core.observable.ObservableUtils;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.base.ui.DocmlBaseUIPlugin;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class DocProcessingConfigStepTab
extends LaunchConfigTabWithDbc
implements IValueChangeListener<Object> {
    protected static final ImList<IDynamicVariable> INPUT_RESOURCE_VAR_DEFS = ResourceVariables.createSingleResourceVarDefs((String)Messages.Variable_InFileResourceVars_description_Resource_term);
    private final OperationItem nullOperationItem = new OperationItem(this){

        @Override
        public String getId() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }
    };
    private final DocProcessingConfigMainTab mainTab;
    private final int num;
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();
    private boolean isNotifyListenerScheduled;
    private final String attrQualifier;
    private final String stepEnabledAttrName;
    private final String operationIdAttrName;
    private final String operationSettingsAttrName;
    private Map<String, String> operationSettings;
    private final IObservableValue<Boolean> stepEnabledValue;
    private final IObservableValue<OperationItem> operationValue;
    private @Nullable ImList<OperationItem> operations;
    private Button stepEnabledControl;
    private final Map<String, IStringVariable> stepVariables = new HashMap<String, IStringVariable>();
    private ComboViewer operationSelectionViewer;
    private StackLayout operationDetailLayout;
    private Composite operationDetailControl;
    private final StringBuilder sBuilder = new StringBuilder(32);

    public DocProcessingConfigStepTab(DocProcessingConfigMainTab mainTab, String attrQualifier) {
        this.mainTab = mainTab;
        this.num = mainTab.addStep(this);
        this.attrQualifier = attrQualifier;
        this.stepEnabledAttrName = this.getAttrQualifier() + "/Run.enabled";
        this.operationIdAttrName = this.getAttrQualifier() + "/Operation.id";
        this.operationSettingsAttrName = this.getAttrQualifier() + "/Operation.settings";
        Realm realm = this.getRealm();
        this.stepEnabledValue = new WritableValue(realm, (Object)true, Boolean.TYPE);
        this.stepEnabledValue.addValueChangeListener((IValueChangeListener)this);
        this.operationValue = new WritableValue(realm, (Object)this.nullOperationItem, OperationItem.class);
        this.operationValue.addValueChangeListener((IValueChangeListener)this);
    }

    protected Realm getRealm() {
        return super.getRealm();
    }

    protected DataBindingContext getDataBindingContext() {
        return super.getDataBindingContext();
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.initVariables(this.stepVariables);
    }

    protected @Nullable ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return super.getLaunchConfigurationDialog();
    }

    public void dispose() {
        ImList<OperationItem> operations = this.operations;
        if (operations != null) {
            for (OperationItem item : operations) {
                item.dipose();
            }
        }
        super.dispose();
    }

    protected final StringBuilder getStringBuilder() {
        this.sBuilder.setLength(0);
        return this.sBuilder;
    }

    public final DocProcessingConfigMainTab getMainTab() {
        return this.mainTab;
    }

    public final int getNum() {
        return this.num;
    }

    protected final String getAttrQualifier() {
        return this.attrQualifier;
    }

    protected String createName(String text) {
        return "&" + this.getNum() + ") " + text;
    }

    public abstract String getLabel();

    public boolean isEnabled() {
        return (Boolean)this.stepEnabledValue.getValue();
    }

    public abstract String getInfo();

    public void addListener(Listener listener) {
        this.listeners.add((Object)((Listener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void scheduleNotifyListeners() {
        if (!this.isNotifyListenerScheduled) {
            this.isNotifyListenerScheduled = true;
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocProcessingConfigStepTab.this.isNotifyListenerScheduled = false;
                    DocProcessingConfigStepTab.this.notifyListeners();
                }
            });
        }
    }

    protected void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.changed(this);
        }
    }

    protected abstract void initVariables(Map<String, IStringVariable> var1);

    public Map<String, IStringVariable> getStepVariables() {
        return this.stepVariables;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(this.getLabel() + ":");
        Button button = new Button(composite, 32);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(Messages.StepTab_Enabled_label);
        this.stepEnabledControl = button;
        this.addControls(mainComposite);
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    protected abstract void addControls(Composite var1);

    protected void setAvailableOperations(List<DocProcessingOperationSettings> operations) {
        if (this.operations != null) {
            throw new IllegalStateException();
        }
        Object[] items = new OperationItem[operations.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = new OperationItem();
            ((OperationItem)items[i]).init(operations.get(i));
            ++i;
        }
        this.operations = ImCollections.newList((Object[])items);
    }

    private OperationItem getOperationItem(String id) {
        ImList<OperationItem> operations = this.operations;
        if (operations == null) {
            throw new UnsupportedOperationException();
        }
        for (OperationItem item : operations) {
            if (item.getId() != id) continue;
            return item;
        }
        return this.nullOperationItem;
    }

    public @Nullable DocProcessingOperationSettings getOperation() {
        OperationItem item = (OperationItem)this.operationValue.getValue();
        return item != null ? item.getOperation() : null;
    }

    protected String getOperationsLabel() {
        return Messages.StepTab_Operations_label;
    }

    protected Composite createOperationGroup(Composite parent) {
        ImList<OperationItem> operations = this.operations;
        if (operations == null) {
            throw new UnsupportedOperationException();
        }
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        composite.setText(this.getOperationsLabel());
        ComboViewer viewer = new ComboViewer((Composite)composite);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        OperationItem[] input = (OperationItem[])operations.toArray((Object[])new OperationItem[operations.size() + 1]);
        input[input.length - 1] = this.nullOperationItem;
        viewer.setInput((Object)input);
        viewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.operationSelectionViewer = viewer;
        Composite detailControl = new Composite((Composite)composite, 0);
        this.operationDetailLayout = new StackLayout();
        detailControl.setLayout((Layout)this.operationDetailLayout);
        detailControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.operationDetailControl = detailControl;
        return composite;
    }

    protected Composite createPostGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.StepTab_PostActions_label);
        return group;
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.stepEnabledControl), this.stepEnabledValue);
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(OperationItem.class).observe((Viewer)this.operationSelectionViewer), this.operationValue);
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (event.getObservable() == this.operationValue) {
            OperationItem newItem;
            OperationItem oldItem = (OperationItem)ObservableUtils.typed(event, this.operationValue).diff.getOldValue();
            if (oldItem != null) {
                oldItem.disable();
            }
            this.operationDetailLayout.topControl = (newItem = (OperationItem)ObservableUtils.typed(event, this.operationValue).diff.getNewValue()) != null ? newItem.enable() : null;
            this.operationDetailControl.layout();
        }
        this.scheduleNotifyListeners();
    }

    protected @Nullable String getDefaultOperationId() {
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.stepEnabledAttrName, true);
        configuration.setAttribute(this.operationIdAttrName, this.getDefaultOperationId());
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        this.stepEnabledValue.setValue((Object)this.readAttribute(configuration, this.stepEnabledAttrName, false));
        String id = this.readAttribute(configuration, this.operationIdAttrName, "").intern();
        OperationItem item = this.getOperationItem(id);
        this.operationValue.setValue((Object)item);
        HashMap<String, String> settings = null;
        try {
            settings = configuration.getAttribute(this.operationSettingsAttrName, null);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
        if (settings == null) {
            settings = new HashMap<String, String>();
        }
        this.operationSettings = settings;
        if (item.getOperation() != null) {
            item.getOperation().load(settings);
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        boolean enabled = (Boolean)this.stepEnabledValue.getValue();
        configuration.setAttribute(this.stepEnabledAttrName, enabled);
        OperationItem item = (OperationItem)this.operationValue.getValue();
        configuration.setAttribute(this.operationIdAttrName, item.getId());
        Map<String, String> settings = this.operationSettings;
        if (item.getOperation() != null) {
            settings = new HashMap<String, String>(settings);
            item.getOperation().save(settings);
        }
        configuration.setAttribute(this.operationSettingsAttrName, settings);
    }

    public static interface Listener {
        public void changed(DocProcessingConfigStepTab var1);
    }

    private class OperationItem {
        private static final byte S_INITIALIZED = 1;
        private static final byte S_CONTROL_FAILED = 32;
        private byte state;
        private DocProcessingOperationSettings operation;
        private @Nullable Composite detailControl;

        private OperationItem() {
        }

        public void init(DocProcessingOperationSettings operation) {
            operation.init(DocProcessingConfigStepTab.this);
            this.state = (byte)(this.state | 1);
            this.operation = operation;
        }

        public void dipose() {
            if (this.operation != null && (this.state & 1) != 0) {
                this.operation.dispose();
            }
        }

        public String getId() {
            return this.operation.getId();
        }

        public DocProcessingOperationSettings getOperation() {
            return this.operation;
        }

        public String toString() {
            return this.operation.getLabel();
        }

        public @Nullable Composite enable() {
            if (this.operation != null) {
                try {
                    this.operation.setSelected(true);
                }
                catch (Exception e) {
                    DocmlBaseUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred when enabling settings for document processing operation ''{0}''.", (Object)this.getId()), (Throwable)e));
                }
                if (this.detailControl == null && (this.state & 0x20) == 0) {
                    try {
                        this.detailControl = this.operation.createDetailControl(DocProcessingConfigStepTab.this.operationDetailControl);
                    }
                    catch (Exception e) {
                        this.state = (byte)(this.state | 0x20);
                        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred when creating GUI for document processing operation ''{0}''.", (Object)this.getId()), (Throwable)e), 3);
                    }
                }
            }
            return this.detailControl;
        }

        public void disable() {
            if (this.operation != null) {
                try {
                    this.operation.setSelected(false);
                }
                catch (Exception e) {
                    DocmlBaseUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred when disabling settings for document processing operation ''{0}''.", (Object)this.getId()), (Throwable)e));
                }
            }
        }
    }
}

