/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;

public abstract class AbstractEditorTemplatesPage
extends AbstractTemplatesPage {
    private final EnhTemplateStore templateStore;
    private final EnhTemplateStore.WorkingCopy templateStoreWorkingCopy;
    private Runnable templateStoreListener;
    private final SourceEditor1 editor;
    private ISourceEditor previewEditor;
    private final TemplateVariableProcessor previewTemplateProcessor;
    private final TemplateVariableProcessor editTemplateProcessor;
    private SourceEditorViewerConfigurator currentPreviewConfigurator;
    private TextViewerJFaceUpdater currentPreviewUpdater;

    protected AbstractEditorTemplatesPage(EnhTemplateStore templateStore, SourceEditor1 editor, ISourceViewer viewer) {
        super((ITextEditor)editor, viewer);
        this.templateStore = templateStore;
        this.templateStoreWorkingCopy = this.templateStore.getWorkingCopy();
        this.editor = editor;
        this.previewTemplateProcessor = new TemplateVariableProcessor();
        this.editTemplateProcessor = new TemplateVariableProcessor();
    }

    protected SourceEditor1 getEditor() {
        return this.editor;
    }

    public TemplateStore getTemplateStore() {
        return this.templateStoreWorkingCopy;
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return this.templateStore.getContextTypeRegistry();
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds = this.getContextTypeIds(document, offset);
        int i = 0;
        while (i < contextIds.length) {
            if (contextIds[i].equals(template.getContextTypeId())) {
                DocumentTemplateContext context = this.createContext(document, template, offset, length);
                return context.canEvaluate(template);
            }
            ++i;
        }
        return false;
    }

    protected void insertTemplate(Template template, IDocument document) {
        ISourceEditor sourceEditor = this.editor.getAdapter(ISourceEditor.class);
        if (!sourceEditor.isEditable(true)) {
            return;
        }
        SourceViewer sourceViewer = sourceEditor.getViewer();
        Point selectedRange = sourceViewer.getSelectedRange();
        DocumentTemplateContext context = this.createContext(document, template, selectedRange.x, selectedRange.y);
        if (context == null) {
            return;
        }
        TextRegion region = LTKSelectionUtils.toTextRegion(selectedRange);
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)context, region, null, 0);
        this.editor.getSite().getPage().activate((IWorkbenchPart)this.editor);
        proposal.apply((ITextViewer)sourceViewer, '\u0000', 0, region.getStartOffset());
    }

    public void createControl(Composite ancestor) {
        if (this.templateStoreListener == null) {
            this.templateStoreListener = new Runnable(){

                @Override
                public void run() {
                    EnhTemplateStore.WorkingCopy templateStore = AbstractEditorTemplatesPage.this.templateStoreWorkingCopy;
                    if (templateStore != null) {
                        templateStore.load();
                    }
                }
            };
            this.templateStore.addListener(this.templateStoreListener);
        }
        this.templateStoreListener.run();
        super.createControl(ancestor);
    }

    public void dispose() {
        if (this.templateStoreListener != null) {
            this.templateStore.removeListener(this.templateStoreListener);
            this.templateStoreListener = null;
        }
        super.dispose();
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        new TextViewerEditorColorUpdater(viewer, EditorsUI.getPreferenceStore());
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        this.previewEditor = new ViewerSourceEditorAdapter(viewer, null);
        new SettingsUpdater(new ISettingsChangedHandler(){

            public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
                if (AbstractEditorTemplatesPage.this.currentPreviewConfigurator != null) {
                    AbstractEditorTemplatesPage.this.currentPreviewConfigurator.handleSettingsChanged(groupIds, options);
                }
            }
        }, viewer.getControl());
        return viewer;
    }

    protected void updatePatternViewer(Template template) {
        SourceViewer patternViewer = this.getPatternViewer();
        if (patternViewer == null || !UIAccess.isOkToUse((Control)patternViewer.getControl())) {
            return;
        }
        if (template != null) {
            SourceEditorViewerConfigurator configurator = this.getTemplatePreviewConfig(template, this.previewTemplateProcessor);
            TemplateContextType type = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
            this.previewTemplateProcessor.setContextType(type);
            if (configurator != this.currentPreviewConfigurator) {
                if (this.currentPreviewUpdater != null) {
                    this.currentPreviewUpdater.dispose();
                    this.currentPreviewUpdater = null;
                }
                if (this.currentPreviewConfigurator != null) {
                    this.currentPreviewConfigurator.unconfigureTarget();
                }
                this.currentPreviewConfigurator = configurator;
                this.currentPreviewConfigurator.setTarget(this.previewEditor);
                this.currentPreviewUpdater = new TextViewerJFaceUpdater((ISourceViewer)patternViewer, this.currentPreviewConfigurator.getSourceViewerConfiguration().getPreferences());
                Document document = new Document();
                this.currentPreviewConfigurator.getDocumentSetupParticipant().setup((IDocument)document);
                this.configureDocument((AbstractDocument)document, type, configurator);
                document.set(template.getPattern());
                patternViewer.setDocument((IDocument)document);
            } else {
                AbstractDocument document = (AbstractDocument)patternViewer.getDocument();
                document.set("");
                this.configureDocument(document, type, configurator);
                document.set(template.getPattern());
            }
        } else {
            patternViewer.getDocument().set("");
        }
        patternViewer.setSelectedRange(0, 0);
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        SourceEditorViewerConfigurator configurator = this.getTemplateEditConfig(template, this.editTemplateProcessor);
        EditTemplateDialog dialog = new EditTemplateDialog(this.getSite().getShell(), template, edit, 1, configurator, this.editTemplateProcessor, (org.eclipse.text.templates.ContextTypeRegistry)this.getContextTypeRegistry(), "org.eclipse.statet.ltk.ui/templates/config"){

            @Override
            protected void configureForContext(TemplateContextType contextType) {
                super.configureForContext(contextType);
                SourceViewer sourceViewer = this.getSourceViewer();
                AbstractDocument document = (AbstractDocument)sourceViewer.getDocument();
                AbstractEditorTemplatesPage.this.configureDocument(document, contextType, this.getSourceViewerConfigurator());
            }
        };
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected abstract DocumentTemplateContext createContext(IDocument var1, Template var2, int var3, int var4);

    protected abstract SourceEditorViewerConfigurator getTemplatePreviewConfig(Template var1, TemplateVariableProcessor var2);

    protected abstract SourceEditorViewerConfigurator getTemplateEditConfig(Template var1, TemplateVariableProcessor var2);

    protected void configureDocument(AbstractDocument document, TemplateContextType contextType, SourceEditorViewerConfigurator configurator) {
    }
}

