/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguageManager1;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceUnit;
import org.eclipse.statet.docmlet.wikitext.ui.config.IMarkupConfigUIAdapter;
import org.eclipse.statet.docmlet.wikitext.ui.editors.IWikidocEditor;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConfigureMarkupHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
        IWikitextSourceUnit su = null;
        if (activePart instanceof IWikidocEditor) {
            IWikidocEditor editor = (IWikidocEditor)activePart;
            su = editor.getSourceUnit();
        }
        if (!(su instanceof IWikidocWorkspaceSourceUnit)) {
            MessageDialog.openInformation((Shell)this.getShell(activePart), (String)"Configure Markup", (String)"The operation only supported for Wikitext documents in the workspace.");
            return null;
        }
        IFile file = (IFile)su.getResource();
        IMarkupLanguageManager1 markupLanguageManager = WikitextCore.getMarkupLanguageManager();
        IMarkupLanguage activeLanguage = markupLanguageManager.getLanguage(file, null, true);
        if (activeLanguage != null) {
            IMarkupConfig config;
            IMarkupConfigUIAdapter ui;
            IMarkupConfig activeConfig = activeLanguage.getMarkupConfig();
            IMarkupConfig fileConfig = markupLanguageManager.getConfig(file, null);
            IMarkupConfigUIAdapter iMarkupConfigUIAdapter = ui = activeConfig != null ? (IMarkupConfigUIAdapter)Platform.getAdapterManager().loadAdapter((Object)activeConfig, IMarkupConfigUIAdapter.class.getName()) : null;
            if (ui == null) {
                MessageDialog.openInformation((Shell)this.getShell(activePart), (String)"Configure Markup", (String)NLS.bind((String)"The operation is not supported for {0}.", (Object)activeLanguage.getName()));
                return null;
            }
            AtomicBoolean enabled = new AtomicBoolean(fileConfig != null);
            if (ui.edit("document", enabled, config = activeConfig.clone(), this.getShell(activePart))) {
                try {
                    activePart.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)new ApplyRunnable((IWikidocWorkspaceSourceUnit)su, (IMarkupConfig)(enabled.get() ? config : null)));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.ui", "An error occurred when setting markup configuration.", (Throwable)e));
                }
            }
        }
        return null;
    }

    protected Shell getShell(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        if (part != null && (site = part.getSite()) != null) {
            return site.getShell();
        }
        return null;
    }

    private static class ApplyRunnable
    implements IRunnableWithProgress {
        private final IWikidocWorkspaceSourceUnit sourceUnit;
        private final IMarkupConfig markupConfig;

        public ApplyRunnable(IWikidocWorkspaceSourceUnit su, IMarkupConfig markupConfig) {
            this.sourceUnit = su;
            this.markupConfig = markupConfig;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Applying markup configuration...", (int)20);
            try {
                IFile file = (IFile)this.sourceUnit.getResource();
                WikitextCore.getMarkupLanguageManager().setConfig(file, this.markupConfig);
                m.worked(20);
            }
            finally {
                m.done();
            }
        }
    }
}

