/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.List;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataEditorOutlinePage;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableVariable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.swt.graphics.Image;

public class RDataLabelProvider
extends StyledCellLabelProvider {
    private final RLabelProvider fRLabelProvider = new RLabelProvider(41);

    public Image getImage(IRDataTableVariable element) {
        switch (element.getVarType()) {
            case 1: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.logi");
            }
            case 2: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.int");
            }
            case 3: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.num");
            }
            case 4: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.cplx");
            }
            case 5: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.char");
            }
            case 6: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.raw");
            }
            case 10: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.factor");
            }
            case 17: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.date");
            }
            case 19: {
                return RUI.getImage("org.eclipse.statet.r.ui/image/obj/col.datetime");
            }
        }
        return null;
    }

    public void update(ViewerCell cell) {
        Image image;
        StyledString text = new StyledString();
        Object element = cell.getElement();
        if (element instanceof RDataTableContentDescription) {
            RDataTableContentDescription description = (RDataTableContentDescription)element;
            if (description.getRElementStruct() instanceof CombinedRElement) {
                this.fRLabelProvider.update(cell, (IModelElement)description.getRElementStruct());
                super.update(cell);
                return;
            }
            switch (description.getRElementStruct().getRObjectType()) {
                case 2: {
                    image = RUI.getImage("org.eclipse.statet.r.ui/image/obj/vector");
                    break;
                }
                case 3: {
                    image = RUI.getImage("org.eclipse.statet.r.ui/image/obj/vector");
                    break;
                }
                case 6: {
                    image = RUI.getImage("org.eclipse.statet.r.ui/image/obj/vector");
                    break;
                }
                default: {
                    image = null;
                }
            }
            text.append(description.getElementName().toString());
        } else if (element instanceof IRDataTableVariable) {
            IRDataTableVariable variable = (IRDataTableVariable)element;
            image = this.getImage(variable);
            text.append(variable.getName());
            if (element instanceof RDataTableColumn) {
                RDataTableColumn column = (RDataTableColumn)variable;
                text.append(" : ", StyledString.DECORATIONS_STYLER);
                List<String> classNames = column.getClassNames();
                text.append(classNames.get(0), StyledString.DECORATIONS_STYLER);
                int i = 1;
                while (i < classNames.size()) {
                    text.append(", ", StyledString.DECORATIONS_STYLER);
                    text.append(classNames.get(i), StyledString.DECORATIONS_STYLER);
                    ++i;
                }
                if (!classNames.contains(RDataUtils.getStoreClass((RStore)column.getDataStore()))) {
                    text.append(" (", StyledString.DECORATIONS_STYLER);
                    text.append(RDataUtils.getStoreAbbr((RStore)column.getDataStore()), StyledString.DECORATIONS_STYLER);
                    text.append(")", StyledString.DECORATIONS_STYLER);
                }
            }
        } else if (element instanceof RDataEditorOutlinePage.VariablePropertyItem) {
            RDataEditorOutlinePage.VariablePropertyItem item = (RDataEditorOutlinePage.VariablePropertyItem)element;
            image = null;
            text.append(item.getName());
            int count = item.getCount();
            if (count >= 0) {
                text.append(" (", StyledString.COUNTER_STYLER);
                text.append(Integer.toString(count), StyledString.COUNTER_STYLER);
                text.append(")", StyledString.COUNTER_STYLER);
            }
        } else {
            image = null;
            text.append(element.toString());
        }
        cell.setText(text.getString());
        cell.setStyleRanges(text.getStyleRanges());
        cell.setImage(image);
        super.update(cell);
    }

    public void dispose() {
        super.dispose();
        this.fRLabelProvider.dispose();
    }
}

