/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.waltable;

import org.eclipse.statet.ecommons.waltable.layer.ILayerListener;

public class LayerListenerList {
    private static final ILayerListener[] EMPTY_ARRAY = new ILayerListener[0];
    private volatile ILayerListener[] listeners = EMPTY_ARRAY;

    public synchronized void add(ILayerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            ILayerListener listener2 = this.listeners[i];
            if (listener == listener2) {
                return;
            }
            ++i;
        }
        ILayerListener[] newListeners = new ILayerListener[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public ILayerListener[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            ILayerListener listener2 = this.listeners[i];
            if (listener == listener2) {
                if (oldSize == 1) {
                    this.listeners = EMPTY_ARRAY;
                } else {
                    ILayerListener[] newListeners = new ILayerListener[oldSize - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public long size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = EMPTY_ARRAY;
    }
}

