/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.TransformLayer;

public class DimensionallyDependentLayer
extends TransformLayer {
    private ILayer horizontalLayerDependency;
    private ILayer verticalLayerDependency;

    public DimensionallyDependentLayer(ILayer baseLayer, ILayer horizontalLayerDependency, ILayer verticalLayerDependency) {
        super(baseLayer);
        this.setHorizontalLayerDependency(horizontalLayerDependency);
        this.setVerticalLayerDependency(verticalLayerDependency);
    }

    protected DimensionallyDependentLayer(ILayer baseLayer) {
        super(baseLayer);
    }

    @Override
    protected void initDims() {
        if (this.horizontalLayerDependency == null || this.verticalLayerDependency == null) {
            return;
        }
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            ILayer dependency = this.getLayerDependency(orientation);
            Dim dim = dependency == this.getBaseLayer() ? new ForwardLayerDim(this, dependency.getDim(orientation)) : new Dim(this, dependency.getDim(orientation));
            this.setDim(dim);
            ++n2;
        }
    }

    protected void setHorizontalLayerDependency(ILayer horizontalLayerDependency) {
        this.horizontalLayerDependency = horizontalLayerDependency;
        this.initDims();
    }

    protected void setVerticalLayerDependency(ILayer verticalLayerDependency) {
        this.verticalLayerDependency = verticalLayerDependency;
        this.initDims();
    }

    public ILayer getHorizontalLayerDependency() {
        return this.horizontalLayerDependency;
    }

    public ILayer getVerticalLayerDependency() {
        return this.verticalLayerDependency;
    }

    public ILayer getLayerDependency(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.horizontalLayerDependency : this.verticalLayerDependency;
    }

    public ILayer getBaseLayer() {
        return this.getUnderlyingLayer();
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        if (this.getBaseLayer() != this.horizontalLayerDependency && this.horizontalLayerDependency.doCommand(command)) {
            return true;
        }
        return this.getBaseLayer() != this.verticalLayerDependency && this.verticalLayerDependency.doCommand(command);
    }

    protected static class Dim
    extends ForwardLayerDim<DimensionallyDependentLayer> {
        public Dim(DimensionallyDependentLayer layer, ILayerDim underlyingDim) {
            super(layer, underlyingDim);
        }

        protected ILayerDim getBaseDim() {
            return ((DimensionallyDependentLayer)this.layer).getBaseLayer().getDim(this.orientation);
        }

        @Override
        public long localToUnderlyingPosition(long refPosition, long position) {
            long id = this.underlyingDim.getPositionId(refPosition, position);
            long underlyingPosition = this.getBaseDim().getPositionById(id);
            if (underlyingPosition == Long.MIN_VALUE) {
                throw PositionOutOfBoundsException.position(position, this.getOrientation());
            }
            return underlyingPosition;
        }

        @Override
        public long underlyingToLocalPosition(ILayerDim sourceUnderlyingDim, long underlyingPosition) {
            if (sourceUnderlyingDim != this.getBaseDim()) {
                throw new IllegalArgumentException("underlyingLayer");
            }
            return this.doUnderlyingToLocalPosition(underlyingPosition);
        }

        @Override
        public List<LRange> underlyingToLocalPositions(ILayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
            if (sourceUnderlyingDim != this.getBaseDim()) {
                throw new IllegalArgumentException("underlyingLayer");
            }
            ArrayList<LRange> localPositions = new ArrayList<LRange>(underlyingPositions.size());
            for (LRange underlyingPositionRange : underlyingPositions) {
                long last;
                if (underlyingPositionRange.start == underlyingPositionRange.end) {
                    long position = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
                    localPositions.add(new LRange(position, position));
                    continue;
                }
                long first = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
                if (first > (last = this.doUnderlyingToLocalPosition(underlyingPositionRange.end - 1L))) continue;
                localPositions.add(new LRange(first, last + 1L));
            }
            return localPositions;
        }

        protected long doUnderlyingToLocalPosition(long underlyingPosition) {
            long id = this.getBaseDim().getPositionId(underlyingPosition, underlyingPosition);
            long position = this.underlyingDim.getPositionById(id);
            if (underlyingPosition == Long.MIN_VALUE) {
                throw PositionOutOfBoundsException.underlyingPosition(underlyingPosition);
            }
            return position;
        }

        @Override
        public List<ILayerDim> getUnderlyingDimsByPosition(long position) {
            return Collections.singletonList(this.getBaseDim());
        }
    }
}

