/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElements;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceFileElement;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

final class RSourceUnitElement
extends RSourceFileElement
implements IBuildSourceFrameElement {
    private final RAstNode sourceNode;
    private List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;

    public RSourceUnitElement(IRSourceUnit su, BuildSourceFrame envir, RAstNode node) {
        super(su, envir);
        this.sourceNode = node;
    }

    @Override
    public void setSourceChildren(List<? extends IRLangSourceElement> children) {
        this.sourceChildrenProtected = children;
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    @Override
    public boolean hasSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
    }

    public TextRegion getSourceRange() {
        return this.sourceNode;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.sourceNode);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RSourceUnitElement");
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }
}

