/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.AbstractConsoleCommandHandler;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.ts.core.util.ToolCommandHandlerUtils;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.views.HistoryView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class EclipseIDEOperationsHandler
extends AbstractConsoleCommandHandler {
    public static final String SHOW_FILE_ID = "common/showFile";
    public static final String SHOW_HISTORY_ID = "common/showHistory";

    @Override
    public Status execute(String id, final ConsoleService service, Map<String, Object> data, final ProgressMonitor m) {
        if (id.equals(SHOW_FILE_ID)) {
            IFileStore fileStore;
            String fileName = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"filename", String.class, (boolean)false);
            if (fileName == null) {
                fileName = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"fileName", String.class, (boolean)true);
            }
            ToolWorkspace workspaceData = service.getWorkspaceData();
            try {
                fileStore = workspaceData.toFileStore(fileName);
            }
            catch (CoreException e) {
                ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "Failed to resolve filename.", (Throwable)e);
                service.handleStatus((Status)status, m);
                return status;
            }
            Display display = UIAccess.getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = NicoUI.getToolRegistry().findWorkbenchPage(service.getTool());
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "An error occurred when trying open/activate the Editor.", (Throwable)e);
                        service.handleStatus((Status)status, m);
                    }
                }
            });
            return Statuses.OK_STATUS;
        }
        if (id.equals(SHOW_HISTORY_ID)) {
            final String pattern = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"pattern", String.class, (boolean)false);
            Display display = UIAccess.getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = NicoUI.getToolRegistry().findWorkbenchPage(service.getTool());
                        HistoryView view = (HistoryView)page.showView("org.eclipse.statet.nico.views.HistoryView");
                        if (pattern != null) {
                            view.search(pattern, false);
                        }
                    }
                    catch (PartInitException e) {
                        ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "An error occurred when trying open/activate the History view.", (Throwable)e);
                        service.handleStatus((Status)status, m);
                    }
                }
            });
            return Statuses.OK_STATUS;
        }
        throw new UnsupportedOperationException();
    }
}

