/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.RChunkBuildElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceFileElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.model.IRCompositeSourceElement;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;

public class CompositeSourceElement
extends RSourceFileElement
implements IRCompositeSourceElement {
    private final ImList<? extends RChunkBuildElement> compositeElements;
    private final TextRegion sourceRange;
    private volatile List<IRLangSourceElement> allSourceChildren;

    public CompositeSourceElement(IRSourceUnit su, BuildSourceFrame envir, List<? extends RChunkBuildElement> elements, TextRegion sourceRange) {
        super(su, envir);
        this.compositeElements = ImCollections.toList(elements);
        this.sourceRange = sourceRange;
    }

    public ImList<? extends IRLangSourceElement> getCompositeElements() {
        return this.compositeElements;
    }

    public TextRegion getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public boolean hasSourceChildren(IModelElement.Filter filter) {
        for (RChunkBuildElement element : this.compositeElements) {
            if (!element.hasSourceChildren(filter)) continue;
            return true;
        }
        return false;
    }

    public List<IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
        if (filter == null) {
            ImList children = this.allSourceChildren;
            if (children == null) {
                Collection[] compositeLists = new List[this.compositeElements.size()];
                int i = 0;
                while (i < compositeLists.length) {
                    compositeLists[i] = ((RChunkBuildElement)this.compositeElements.get(i)).getSourceChildren(null);
                    ++i;
                }
                children = this.allSourceChildren = ImCollections.concatList((Collection[])compositeLists);
            }
            return children;
        }
        ArrayList<IRLangSourceElement> children = new ArrayList<IRLangSourceElement>();
        for (RChunkBuildElement element : this.compositeElements) {
            List<? extends IRLangSourceElement> list = element.getSourceChildren(null);
            for (IRLangSourceElement child : list) {
                if (!filter.include((IModelElement)child)) continue;
                children.add(child);
            }
        }
        return children;
    }
}

