/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.UriUtils;

@NonNullByDefault
public class PathEntry
implements Comparable<PathEntry> {
    protected final String bundleId;
    private final Path path;

    public PathEntry(String bundleId, Path path) {
        this.bundleId = bundleId;
        this.path = path;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    @Override
    public int compareTo(PathEntry o) {
        return this.bundleId.compareTo(o.bundleId);
    }

    protected Path getPath() {
        return this.path;
    }

    public String getUrlString() {
        return this.path.toUri().toString();
    }

    public String getJClassPathString() {
        return this.path.toString();
    }

    public String getCodebaseString() {
        return this.path.toUri().toString();
    }

    public @Nullable Path getResourcePath(String resource) {
        Path path = this.path.resolve(resource);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    public int hashCode() {
        return this.bundleId.hashCode() + this.getPath().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathEntry) {
            PathEntry other = (PathEntry)obj;
            return this.bundleId.equals(other.bundleId) && this.getPath().equals(other.getPath());
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format("'%1$s' -> '%2$s'", this.bundleId, this.getUrlString());
    }

    public static class Jar
    extends PathEntry {
        public Jar(String bundleId, Path path) {
            super(bundleId, path);
        }

        @Override
        public String getUrlString() {
            try {
                return UriUtils.toJarUrlString((String)super.getUrlString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @Nullable Path getResourcePath(String resource) {
            return null;
        }
    }
}

