/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvManager;

@NonNullByDefault
public class BasicREnvManager
implements REnvManager {
    private static final Pattern ID_PATTERN = Pattern.compile("[\\w_.]+");
    private ImList<ActualREnv> list = ImCollections.emptyList();

    public ImList<ActualREnv> list() {
        return this.list;
    }

    @Override
    public @Nullable REnv get(@Nullable String id, @Nullable String name) {
        ImList<ActualREnv> list = this.list;
        if (id != null) {
            for (REnv rEnv : list) {
                if (!rEnv.getId().equals(id)) continue;
                return rEnv;
            }
        }
        if (name != null) {
            for (REnv rEnv : list) {
                if (!rEnv.getName().equals(name)) continue;
                return rEnv;
            }
        }
        return null;
    }

    @Override
    public void add(REnvConfiguration rEnvConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(REnv rEnv) {
        throw new UnsupportedOperationException();
    }

    protected boolean isValidId(String id) {
        return ID_PATTERN.matcher(id).matches();
    }

    protected ActualREnv newEnv(String id) {
        if (!this.isValidId(id)) {
            throw new IllegalArgumentException("id=" + id);
        }
        return new ActualREnv(id.intern());
    }

    protected void setActualEnvs(ImList<ActualREnv> list) {
        this.list = list;
    }

    protected void updateEnv(ActualREnv rEnv, @Nullable REnvConfiguration config) {
        if (config != null) {
            rEnv.name = config.getName();
            rEnv.config = config;
        } else {
            rEnv.isDeleted = true;
        }
    }

    protected static class ActualREnv
    extends REnv {
        private String name;
        private boolean isDeleted;
        private REnvConfiguration config;

        public ActualREnv(String id) {
            super(id);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public REnv resolve() {
            return this;
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        protected REnvConfiguration getConfiguration() {
            return this.config;
        }

        @Override
        public <T> @Nullable T get(Class<T> type) {
            if (type == REnvConfiguration.class) {
                return (T)this.getConfiguration();
            }
            return null;
        }
    }
}

