/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractIntegerStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;

public class RInteger32Store
extends AbstractIntegerStore
implements RDataResizeExtension<Integer>,
ExternalizableRStore,
Externalizable {
    private int length;
    protected int[] intValues;

    public RInteger32Store() {
        this.length = 0;
        this.intValues = EMPTY_INT_ARRAY;
    }

    public RInteger32Store(int length) {
        this.intValues = new int[length];
        this.length = length;
    }

    public RInteger32Store(int[] values) {
        this.length = values.length;
        this.intValues = values;
    }

    public RInteger32Store(int[] values, int length) {
        this.length = length;
        this.intValues = values;
    }

    public RInteger32Store(int[] values, int[] naIdxs) {
        this.length = values.length;
        this.intValues = values;
        if (naIdxs != null) {
            int i = 0;
            while (i < naIdxs.length) {
                this.intValues[naIdxs[i]] = Integer.MIN_VALUE;
                ++i;
            }
        }
    }

    public RInteger32Store(RJIO io, int length) throws IOException {
        this.length = length;
        this.intValues = io.readIntData(new int[length], length);
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        io.writeIntData(this.intValues, this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.length = in.readInt();
        this.intValues = new int[this.length];
        int i = 0;
        while (i < this.length) {
            this.intValues[i] = in.readInt();
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        int i = 0;
        while (i < this.length) {
            out.writeInt(this.intValues[i]);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    protected final int length() {
        return this.length;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.intValues[idx] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.intValues[(int)idx] == Integer.MIN_VALUE;
    }

    @Override
    public void setNA(int idx) {
        this.intValues[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.intValues[(int)idx] = Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.intValues[idx] == Integer.MIN_VALUE;
    }

    @Override
    public boolean isMissing(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.intValues[(int)idx] == Integer.MIN_VALUE;
    }

    @Override
    public int getInt(int idx) {
        return this.intValues[idx];
    }

    @Override
    public int getInt(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.intValues[(int)idx];
    }

    @Override
    public void setInt(int idx, int value) {
        this.intValues[idx] = value;
    }

    @Override
    public void setInt(long idx, int value) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.intValues[(int)idx] = value;
    }

    private void prepareInsert(int[] idxs) {
        this.intValues = RInteger32Store.prepareInsert(this.intValues, this.length, idxs);
        this.length += idxs.length;
    }

    public void insertInt(int idx, int value) {
        this.prepareInsert(new int[]{idx});
        this.intValues[idx] = value;
    }

    @Override
    public void insertNA(int idx) {
        this.prepareInsert(new int[]{idx});
        this.intValues[idx] = Integer.MIN_VALUE;
    }

    @Override
    public void insertNA(int[] idxs) {
        if (idxs.length == 0) {
            return;
        }
        this.prepareInsert(idxs);
        int idx = 0;
        while (idx < idxs.length) {
            this.intValues[idxs[idx] + idx] = Integer.MIN_VALUE;
            ++idx;
        }
    }

    @Override
    public void remove(int idx) {
        this.intValues = RInteger32Store.remove(this.intValues, this.length, new int[]{idx});
        --this.length;
    }

    @Override
    public void remove(int[] idxs) {
        this.intValues = RInteger32Store.remove(this.intValues, this.length, idxs);
        this.length -= idxs.length;
    }

    @Override
    public Integer get(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int v = this.intValues[idx];
        return v != Integer.MIN_VALUE ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer get(long idx) {
        if (idx < 0L || idx >= (long)this.length()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        int v = this.intValues[(int)idx];
        return v != Integer.MIN_VALUE ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer[] toArray() {
        Integer[] array = new Integer[this.length()];
        int[] ints = this.intValues;
        int i = 0;
        while (i < array.length) {
            int v = ints[i];
            if (v != Integer.MIN_VALUE) {
                array[i] = v;
            }
            ++i;
        }
        return array;
    }

    @Override
    public final long indexOfNA(long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        int[] ints = this.intValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (ints[i] == Integer.MIN_VALUE) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    @Override
    public final long indexOf(int integer, long fromIdx) {
        if (fromIdx >= Integer.MAX_VALUE || integer == Integer.MIN_VALUE) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int l = this.length();
        int[] ints = this.intValues;
        int i = (int)fromIdx;
        while (i < l) {
            if (ints[i] == integer) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public void appendTo(StringBuilder sb) {
        sb.append('[');
        int l = this.length();
        if (l > 0) {
            int[] ints = this.intValues;
            int i = 0;
            while (i < l) {
                sb.append(ints[i]);
                sb.append(", ");
                ++i;
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
    }
}

