/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.processing;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigIOStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigMainTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.docmlet.base.ui.processing.operations.DocProcessingConfigOpenFileSetting;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.redocs.tex.r.ui.processing.Messages;
import org.eclipse.statet.internal.redocs.tex.r.ui.processing.TexRweaveConfig;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.statet.redocs.r.ui.processing.RunRCmdToolOperationSettings;
import org.eclipse.statet.redocs.r.ui.processing.RunRConsoleSnippetOperationSettings;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TexTab
extends DocProcessingConfigIOStepTab {
    private final DocProcessingConfigOpenFileSetting openResult;

    public TexTab(DocProcessingConfigMainTab mainTab) {
        super(mainTab, "org.eclipse.statet.redocs/weave");
        this.setInput(TexRweaveConfig.SOURCE_FORMAT, null);
        this.setAvailableOutputFormats((List)TexRweaveConfig.WEAVE_OUTPUT_FORMATS, "ext:ltx");
        this.setAvailableOperations((List)ImCollections.newList((Object[])new DocProcessingOperationSettings[]{new RunRConsoleSnippetOperationSettings(), new RunRCmdToolOperationSettings()}));
        Realm realm = this.getRealm();
        this.openResult = new DocProcessingConfigOpenFileSetting("org.eclipse.statet.redocs/weave/Post.OpenOutput.enabled", realm);
    }

    public Image getImage() {
        return RedocsRUIResources.INSTANCE.getImage("org.eclipse.statet.redocs.r/image/tool/rweave");
    }

    public String getName() {
        return this.createName(Messages.WeaveTab_name);
    }

    public String getLabel() {
        return Messages.Weave_label;
    }

    private void updateInput() {
        this.setInput(TexRweaveConfig.SOURCE_FORMAT, this.getMainTab().getSourceFile());
    }

    protected void addControls(Composite parent) {
        this.updateInput();
        super.addControls(parent);
        Composite group = this.createPostGroup(parent);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Composite createPostGroup(Composite parent) {
        Composite group = super.createPostGroup(parent);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        ComboViewer viewer = this.openResult.createControls(group, Messages.WeaveTab_OpenResult_label);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        return group;
    }

    protected void addBindings(DataBindingContext dbc) {
        super.addBindings(dbc);
        this.openResult.addBindings(dbc);
    }

    protected String getDefaultOperationId() {
        return "org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        super.doInitialize(configuration);
        try {
            this.openResult.load(configuration);
        }
        catch (CoreException e) {
            this.logReadingError(e);
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        super.doSave(configuration);
        this.openResult.save(configuration);
    }
}

