/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class TogglePreferenceEnablementHandler
extends AbstractHandler
implements IElementUpdater,
IEclipsePreferences.IPreferenceChangeListener {
    private final Preference<Boolean> pref;
    private final PreferenceAccess prefAccess;
    private boolean isPrefEnabled;
    private final String commandId;

    public TogglePreferenceEnablementHandler(Preference<Boolean> pref, String commandId) {
        this(pref, PreferenceUtils.getInstancePrefs(), commandId);
    }

    public TogglePreferenceEnablementHandler(Preference<Boolean> pref, PreferenceAccess access, String commandId) {
        this.pref = pref;
        this.prefAccess = access;
        this.commandId = commandId;
        this.prefAccess.addPreferenceNodeListener(this.pref.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        this.isPrefEnabled = (Boolean)this.prefAccess.getPreferenceValue(this.pref);
        this.setBaseEnabled(true);
    }

    protected final boolean isPrefEnabled() {
        return this.isPrefEnabled;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.pref.getKey().equals(event.getKey())) {
            Boolean newValue = (Boolean)this.prefAccess.getPreferenceValue(this.pref);
            if (newValue == null) {
                return;
            }
            boolean newEnablement = newValue;
            if (newEnablement != this.isPrefEnabled) {
                this.isPrefEnabled = newEnablement;
                this.handleToggled(newEnablement);
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                if (this.commandId != null && commandService != null) {
                    WorkbenchUIUtils.refreshCommandElements(this.commandId, (IHandler2)this, null);
                }
            }
        }
    }

    protected void handleToggled(boolean enabled) {
    }

    public void dispose() {
        this.prefAccess.removePreferenceNodeListener(this.pref.getQualifier(), (IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
        try {
            element.setChecked(this.isPrefEnabled);
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        PreferenceUtils.setPrefValue((IScopeContext)((IScopeContext)this.prefAccess.getPreferenceContexts().get(0)), this.pref, (Object)(!this.isPrefEnabled ? 1 : 0), (int)2);
        return null;
    }
}

