/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandCategories;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.docmlet.tex.ui.editors.ILtxEditor;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.ui.actions.SubMenuContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.LtxCommandCompletionProposal;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.statushandlers.StatusManager;

public class LtxSymbolsMenuContributions
extends CompoundContributionItem {
    private LtxCommandCategories categories;

    protected IContributionItem[] getContributionItems() {
        this.categories = new LtxCommandCategories(TexCore.getWorkbenchAccess().getTexCommandSet().getAllLtxCommands()){

            protected boolean include(TexCommand command) {
                return (command.getType() & 0xF) == 11 && (command.getType() & 0xFFF) != 2907;
            }
        };
        List categories = this.categories.getCategories();
        ArrayList<Object> items = new ArrayList<Object>(categories.size() + 10);
        int sep = 0;
        for (LtxCommandCategories.Category category : categories) {
            int current = ((TexCommand)category.getCommands().get(0)).getType() & 0xFF;
            if (sep != current) {
                sep = current;
                if (items.size() > 0) {
                    items.add(new Separator());
                }
            }
            items.add((Object)new CategoryContributions(category));
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private static class CategoryContributions
    extends SubMenuContributionItem
    implements SelectionListener {
        private final LtxCommandCategories.Category category;

        public CategoryContributions(LtxCommandCategories.Category category) {
            this.category = category;
        }

        protected Image getImage() {
            return null;
        }

        protected String getLabel() {
            return this.category.getLabel();
        }

        protected void fillMenu(Menu menu) {
            TexUIResources texResources = TexUIResources.INSTANCE;
            List commands = this.category.getCommands();
            for (TexCommand command : commands) {
                MenuItem item = new MenuItem(menu, 8);
                String imageKey = texResources.getCommandImageId(command);
                if (imageKey != null) {
                    item.setImage(texResources.getImage(imageKey));
                }
                item.setText(command.getControlWord());
                item.setData((Object)command);
                item.addSelectionListener((SelectionListener)this);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            TexCommand command = (TexCommand)event.widget.getData();
            IEditorPart editor = UIAccess.getActiveWorkbenchPage((boolean)true).getActiveEditor();
            if (editor instanceof ILtxEditor) {
                ILtxEditor texEditor = (ILtxEditor)editor;
                if (!texEditor.isEditable(true)) {
                    return;
                }
                SourceViewer viewer = ((ILtxEditor)editor).getViewer();
                Point selection = viewer.getSelectedRange();
                if (selection == null || selection.x < 0) {
                    return;
                }
                try {
                    String contentType = TextUtils.getContentType((IDocument)viewer.getDocument(), (IDocContentSections)texEditor.getDocumentContentInfo(), (int)selection.x, (selection.y == 0 ? 1 : 0) != 0);
                    LtxAssistInvocationContext context = new LtxAssistInvocationContext(texEditor, selection.x, contentType, true, (IProgressMonitor)new NullProgressMonitor());
                    LtxCommandCompletionProposal proposal = new LtxCommandCompletionProposal(context, context.getInvocationOffset(), command);
                    proposal.apply((ITextViewer)viewer, '\u0000', 1, context.getInvocationOffset());
                    selection = proposal.getSelection(viewer.getDocument());
                    if (selection != null) {
                        viewer.setSelectedRange(selection.x, selection.y);
                        viewer.revealRange(selection.x, selection.y);
                    } else {
                        viewer.revealRange(context.getInvocationOffset(), 0);
                    }
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", "An error occurred when inserting LaTeX symbol.", (Throwable)e));
                }
            }
        }
    }
}

