/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolOperationContext;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolOperationIterator;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.ecommons.debug.core.model.AbstractProcess;
import org.eclipse.statet.ecommons.runtime.core.util.EnrichProgressMonitor;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.statushandlers.StatusManager;

public class DocProcessingToolProcess
extends AbstractProcess {
    private static final int CONTEXT_TICKS = 10;
    private static final int STEP_TICKS = 10;
    private final DocProcessingToolConfig config;
    private final Image image;
    private EnrichProgressMonitor enrichMonitor;
    private SubMonitor monitor;
    private Thread workerThread;
    private final MultiStatus status;
    private List<DocProcessingToolOperationContext> contexts;
    private final DocProcessingToolOperationIterator nextContextIterator;
    private String currentContextId;
    private DocProcessingToolOperationContext currentContext;
    private final DocProcessingToolOperationIterator operationIterator;
    private DocProcessingToolConfig.StepConfig currentStepConfig;

    private static String createName(ILaunchConfiguration config, IFile file) {
        Object[] names = new String[3];
        try {
            names[0] = config.getType().getName();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (names[0] == null) {
            names[0] = "Document Processing";
        }
        names[1] = config.getName();
        names[2] = file.getName();
        return NLS.bind((String)Messages.ProcessingProcess_label, (Object[])names);
    }

    public DocProcessingToolProcess(ILaunch launch, DocProcessingToolConfig config) {
        super(launch, DocProcessingToolProcess.createName(launch.getLaunchConfiguration(), config.getSourceFile()));
        this.config = config;
        this.operationIterator = new DocProcessingToolOperationIterator(config.getSteps());
        this.nextContextIterator = new DocProcessingToolOperationIterator(config.getSteps());
        this.status = new MultiStatus("org.eclipse.statet.docmlet.base.ui", 0, this.getLabel(), null);
        this.image = this.fetchImage();
    }

    protected Image fetchImage() {
        try {
            ILaunchConfiguration configuration = this.getLaunch().getLaunchConfiguration();
            if (configuration != null) {
                String contentTypeId = configuration.getAttribute("org.eclipse.statet.docmlet.base/run/ContentType.id", null);
                DocProcessingManager manager = null;
                if (contentTypeId != null) {
                    DocProcessingUI.getDocProcessingManager(contentTypeId);
                } else {
                    IContentType contentType = this.config.getSourceFile().getContentDescription().getContentType();
                    if (contentType != null) {
                        manager = DocProcessingUI.getDocProcessingManager(contentType, true);
                    }
                }
                if (manager != null) {
                    return manager.getActionImage((IdentityCollection)configuration.getAttribute("org.eclipse.statet.docmlet.base/run/BuildSteps.set", Collections.EMPTY_SET));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Image getImage() {
        return this.image;
    }

    public DocProcessingToolConfig getConfig() {
        return this.config;
    }

    public final MultiStatus getStatus() {
        return this.status;
    }

    public void check(IStatus status) throws CoreException {
        switch (status.getSeverity()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: {
                this.log(status);
                return;
            }
        }
        throw new CoreException(status);
    }

    public void check(org.eclipse.statet.jcommons.status.Status status) throws CoreException {
        switch (status.getSeverity()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: {
                this.log(status);
                return;
            }
        }
        throw new CoreException(StatusUtils.convert((org.eclipse.statet.jcommons.status.Status)status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(IStatus status) {
        MultiStatus multiStatus = this.status;
        synchronized (multiStatus) {
            if (status.getSeverity() == 8 && (this.status.getSeverity() == 4 || this.status.getSeverity() == 8 && status == Status.CANCEL_STATUS)) {
                return;
            }
            this.status.add(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(org.eclipse.statet.jcommons.status.Status status) {
        MultiStatus multiStatus = this.status;
        synchronized (multiStatus) {
            if (status.getSeverity() == 8 && (this.status.getSeverity() == 4 || this.status.getSeverity() == 8 && status == Statuses.CANCEL_STATUS)) {
                return;
            }
            this.status.add(StatusUtils.convert((org.eclipse.statet.jcommons.status.Status)status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldContinue() {
        MultiStatus multiStatus = this.status;
        synchronized (multiStatus) {
            block6: {
                block5: {
                    int severity = this.status.getSeverity();
                    if (severity < 4) break block5;
                    return false;
                }
                SubMonitor monitor = this.monitor;
                if (monitor == null || !monitor.isCanceled()) break block6;
                this.status.add(Status.CANCEL_STATUS);
                return false;
            }
            return true;
        }
    }

    public ISchedulingRule beginSchedulingRule(ISchedulingRule rule, IProgressMonitor monitor) throws OperationCanceledException {
        if (rule != null) {
            Job.getJobManager().beginRule(rule, monitor);
        }
        return rule;
    }

    public void endSchedulingRule(ISchedulingRule rule) {
        if (rule != null) {
            Job.getJobManager().endRule(rule);
        }
    }

    public DocProcessingToolOperationContext getCurrentOperationContext() {
        return this.currentContext;
    }

    public String getCurrentStepLabel() {
        DocProcessingToolConfig.StepConfig stepConfig = this.operationIterator.getStepConfig();
        return stepConfig != null ? stepConfig.getLabel() : "";
    }

    public boolean canTerminate() {
        return this.monitor != null;
    }

    public boolean isTerminated() {
        return this.monitor == null;
    }

    public void terminate() throws DebugException {
        Thread thread;
        DocProcessingToolOperationContext context;
        SubMonitor monitor = this.monitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        if ((context = this.currentContext) != null) {
            context.cancel();
        }
        if ((thread = this.workerThread) != null) {
            thread.interrupt();
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        block5: {
            this.enrichMonitor = monitor != null ? new EnrichProgressMonitor(monitor) : null;
            this.monitor = SubMonitor.convert((IProgressMonitor)this.enrichMonitor, (String)this.getLabel(), (int)this.calculateTicks());
            this.workerThread = Thread.currentThread();
            this.created();
            try {
                try {
                    this.runProcessing(this.monitor);
                }
                catch (Throwable e) {
                    this.doSetExitValue(-1);
                    this.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, Messages.ProcessingProcess_error_UnexpectedError_message, e));
                    this.runFinished();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.runFinished();
                throw throwable;
            }
            this.runFinished();
        }
        return this.getStatus();
    }

    protected void stepChanged(DocProcessingToolConfig.StepConfig finishedStepConfig, DocProcessingToolConfig.StepConfig nextStepConfig) {
        SubMonitor m;
        if (finishedStepConfig != null && (m = this.monitor) != null) {
            m.worked(10);
        }
        this.currentStepConfig = nextStepConfig;
        m = this.enrichMonitor;
        if (m != null) {
            m.setPrefix(nextStepConfig != null ? String.valueOf('[') + nextStepConfig.getLabel() + "] " : null);
        }
    }

    protected void runFinished() {
        if (this.status.getSeverity() > 2) {
            int exitValue = this.doGetExitValue();
            if (exitValue == 0) {
                exitValue = 1;
                this.doSetExitValue(1);
            }
            this.log((IStatus)new Status(1, "org.eclipse.statet.docmlet.base.ui", "Exit code= " + exitValue));
        }
        if (this.status.getSeverity() > 1) {
            StatusManager.getManager().handle((IStatus)this.status, 1);
        }
        this.enrichMonitor = null;
        this.monitor = null;
        this.workerThread = null;
        this.terminated();
    }

    protected int calculateTicks() {
        try {
            int ticks = 0;
            String currentContextId = null;
            String currentStepId = null;
            while (this.operationIterator.next()) {
                String contextId;
                DocProcessingOperation operation = this.operationIterator.getOperation();
                String stepId = this.operationIterator.getStepConfig().getId();
                if (currentStepId != stepId) {
                    ticks += 10;
                    currentStepId = stepId;
                }
                if (this.isContextRequired(this.operationIterator) && (contextId = operation.getContextId()) != currentContextId) {
                    ticks += 10;
                    currentContextId = contextId;
                }
                ticks += operation.getTicks();
            }
            int n = ticks;
            return n;
        }
        finally {
            this.operationIterator.reset();
        }
    }

    protected void runProcessing(SubMonitor progress) {
        this.operationIterator.reset();
        this.operationIterator.hasNext();
        this.stepChanged(null, this.operationIterator.getStepConfig());
        this.executeOperations();
    }

    protected void executeOperations() {
        while (this.operationIterator.hasNext() && this.shouldContinue()) {
            String contextId = this.getNextRequiredContextId();
            if (contextId != this.currentContextId) {
                if (this.currentContextId == null) {
                    this.startNextRequiredContext();
                    continue;
                }
                return;
            }
            this.executeNextOperation();
        }
    }

    private boolean isContextRequired(DocProcessingToolOperationIterator iterator) {
        return iterator.getOperation().getContextId() != null || iterator.getStepPart() == 2;
    }

    private String getNextRequiredContextId() {
        if (this.nextContextIterator.compareTo(this.operationIterator) < 0) {
            this.nextContextIterator.reset(this.operationIterator);
        }
        while (this.nextContextIterator.hasNext()) {
            if (this.isContextRequired(this.nextContextIterator)) {
                return this.nextContextIterator.getOperation().getContextId();
            }
            this.nextContextIterator.next();
        }
        return null;
    }

    private void startNextRequiredContext() {
        IStatus status = this.startContext(this.getContext(this.nextContextIterator.getOperation()));
        if (status.getSeverity() != 0) {
            this.log(status);
        }
    }

    protected DocProcessingToolOperationContext getContext(DocProcessingOperation operation) {
        String id = operation.getContextId();
        if (id == null) {
            return null;
        }
        if (this.contexts == null) {
            this.contexts = new ArrayList<DocProcessingToolOperationContext>(4);
        } else {
            for (DocProcessingToolOperationContext aContext : this.contexts) {
                if (id != aContext.getId()) continue;
                return aContext;
            }
        }
        DocProcessingToolOperationContext context = operation.createContext();
        if (context == null) {
            throw new NullPointerException("context: id= " + id);
        }
        this.contexts.add(context);
        return context;
    }

    protected IStatus startContext(DocProcessingToolOperationContext context) {
        assert (this.currentContext == null);
        this.currentContext = context;
        this.currentContextId = context.getId();
        try {
            this.currentContext.start(this, new Runnable(){

                @Override
                public void run() {
                    DocProcessingToolProcess.this.executeOperations();
                }
            }, this.monitor.newChild(10, 0));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingProcess_RunInContext_error_Failed_message, (Object)context.getLabel()), (Throwable)e);
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingProcess_RunInContext_error_UnexpectedError_message, (Object)context.getLabel()), (Throwable)e);
            return status;
        }
        finally {
            this.currentContext = null;
            this.currentContextId = null;
        }
    }

    private void executeNextOperation() {
        try {
            IStatus status = this.executeOperation(this.operationIterator.getOperation());
            if (status.getSeverity() != 0) {
                this.log(status);
            }
        }
        finally {
            this.operationIterator.next();
            DocProcessingToolConfig.StepConfig nextStepConfig = this.operationIterator.getStepConfig();
            if (nextStepConfig != this.currentStepConfig) {
                this.stepChanged(this.currentStepConfig, nextStepConfig);
            }
        }
    }

    protected IStatus executeOperation(DocProcessingOperation operation) {
        SubMonitor m = this.monitor.newChild(operation.getTicks(), 0);
        try {
            IStatus iStatus = operation.run(this, m);
            return iStatus;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingProcess_RunOperation_error_Failed_message, (Object)operation.getLabel(), (Object)this.getCurrentStepLabel()), (Throwable)e);
            return status;
        }
        catch (OperationCanceledException e) {
            Status status = new Status(8, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingProcess_RunOperation_error_Cancelled_message, (Object)operation.getLabel(), (Object)this.getCurrentStepLabel()), (Throwable)e);
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingProcess_RunOperation_error_UnexpectedError_message, (Object)operation.getLabel(), (Object)this.getCurrentStepLabel()), (Throwable)e);
            return status;
        }
        finally {
            m.done();
        }
    }
}

