/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.ltk.model.core.ISourceUnitFactory;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public abstract class AbstractFilePersistenceSourceUnitFactory
implements ISourceUnitFactory {
    private static final String IFILE_PREFIX = "platform:/resource";

    public static String createResourceId(IResource file) {
        IPath path;
        if (file != null && (path = file.getFullPath()) != null) {
            return IFILE_PREFIX + path.toPortableString();
        }
        return null;
    }

    public static String createResourceId(URI uri) {
        if (uri != null) {
            if ((uri = uri.normalize()).getScheme() == null) {
                return "xxx:" + uri.toString();
            }
            return uri.toString();
        }
        return null;
    }

    @Override
    public String createId(Object from) {
        String s;
        if (from instanceof IFile) {
            return AbstractFilePersistenceSourceUnitFactory.createResourceId((IResource)((IFile)from));
        }
        if (from instanceof String && (s = (String)from).startsWith(IFILE_PREFIX)) {
            return s;
        }
        return null;
    }

    @Override
    public ISourceUnit createSourceUnit(String id, Object from) {
        IFile ifile;
        if (from instanceof IFile) {
            ifile = (IFile)from;
        } else {
            IPath path = Path.fromPortableString((String)id.substring(IFILE_PREFIX.length()));
            ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return this.createSourceUnit(id, ifile);
    }

    protected abstract ISourceUnit createSourceUnit(String var1, IFile var2);
}

