/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.cell;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;

public class LayerCellDim
implements ILayerCellDim {
    private final Orientation orientation;
    private final long id;
    private final long position;
    private final long originPosition;
    private final long positionSpan;

    public LayerCellDim(Orientation orientation, long id, long position) {
        this(orientation, id, position, position, 1L);
    }

    public LayerCellDim(Orientation orientation, long id, long position, long originPosition, long positionSpan) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        if (positionSpan < 0L || position < originPosition || position >= originPosition + positionSpan) {
            throw new IllegalArgumentException("position: " + position + " [" + originPosition + ", " + (originPosition + positionSpan) + "]");
        }
        this.orientation = orientation;
        this.id = id;
        this.position = position;
        this.originPosition = originPosition;
        this.positionSpan = positionSpan;
    }

    @Override
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final long getPosition() {
        return this.position;
    }

    @Override
    public final long getOriginPosition() {
        return this.originPosition;
    }

    @Override
    public final long getPositionSpan() {
        return this.positionSpan;
    }

    public final int hashCode() {
        int h = (int)(this.originPosition ^ this.originPosition >>> 32);
        if (this.orientation == Orientation.VERTICAL) {
            h = 17 + Integer.rotateRight(h, 15);
        }
        return h ^ h >>> 7;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LayerCellDim) {
            LayerCellDim other = (LayerCellDim)obj;
            return this.orientation == other.orientation && this.originPosition == other.originPosition && this.positionSpan == other.positionSpan;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id= ").append(this.id);
        sb.append(", ").append("position: ").append(this.position);
        sb.append(" [").append(this.originPosition).append(", ").append(this.originPosition + this.positionSpan).append("]");
        return sb.toString();
    }
}

