/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.eruntime;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.UriUtils;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.PathEntry;
import org.eclipse.statet.rj.server.util.RJContext;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ERJContext
extends RJContext {
    private static final String BUNDLE_ID = "org.eclipse.statet.rj.server";

    private static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)BUNDLE_ID)).log(status);
    }

    @Override
    public List<PathEntry> searchRJLibs(List<String> libIds) {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        LinkedHashSet<PathEntry> resolved = new LinkedHashSet<PathEntry>();
        for (String libId : libIds) {
            Bundle pluginBundle = Platform.getBundle((String)libId);
            if (pluginBundle == null) continue;
            this.addPath(pluginBundle, resolved, statusList);
            Bundle[] fragments = Platform.getFragments((Bundle)pluginBundle);
            if (fragments == null) continue;
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragmentBundle = bundleArray[n2];
                this.addPath(fragmentBundle, resolved, statusList);
                ++n2;
            }
        }
        if (!statusList.isEmpty()) {
            ERJContext.log((IStatus)new MultiStatus(BUNDLE_ID, 0, statusList.toArray(new IStatus[statusList.size()]), "An error occurred when looking up RJ libraries. This may cause problems starting/running RJ.", null));
        }
        return ImCollections.toList(resolved);
    }

    private void addPath(Bundle bundle, Set<PathEntry> classpath, List<IStatus> statusList) {
        try {
            Path binPath;
            String libId = (String)ObjectUtils.nonNullAssert((Object)bundle.getSymbolicName());
            URI url = UriUtils.toUri((URL)FileLocator.resolve((URL)bundle.getEntry("/")));
            if (UriUtils.isJarUrl((URI)url) && UriUtils.getJarEntryPath((URI)url).isEmpty()) {
                url = UriUtils.getJarFileUrl((URI)url);
            }
            Path path = Paths.get(url);
            if (Platform.inDevelopmentMode() && Files.isDirectory(binPath = path.resolve("bin"), new LinkOption[0])) {
                classpath.add(new PathEntry(libId, binPath));
            }
            classpath.add(new PathEntry(libId, path));
            return;
        }
        catch (Exception e) {
            statusList.add((IStatus)new Status(2, BUNDLE_ID, String.format("Failed to check location for plug-in: '%1$s'.", bundle.getSymbolicName()), (Throwable)e));
            return;
        }
    }

    @Override
    public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
        try {
            Bundle bundle = Platform.getBundle((String)BUNDLE_ID);
            if (bundle == null) {
                throw new RjInvalidConfigurationException(String.format("RJ bundle '%1$s' is missing.", BUNDLE_ID));
            }
            URL intern = bundle.getEntry("/localhost.policy");
            URL java = FileLocator.resolve((URL)intern);
            String path = java.toExternalForm();
            return path;
        }
        catch (IOException e) {
            throw new RjInvalidConfigurationException("Failed find server policy file.", e);
        }
    }
}

