/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;

class RExprDropAdapter
extends DropTargetAdapter {
    private final List<RExprTypeUIAdapter> uiAdapters;

    public RExprDropAdapter(List<RExprTypeUIAdapter> uiAdapters) {
        this.uiAdapters = uiAdapters;
    }

    public void dragEnter(DropTargetEvent event) {
        this.dragOperationChanged(event);
        if (event.detail == 0) {
            return;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (selection instanceof IStructuredSelection && this.isValidInput(selection, event)) {
                return;
            }
            event.detail = 0;
            return;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16 || event.detail == 0) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void drop(DropTargetEvent event) {
        if (!this.performDrop(event)) {
            event.detail = 0;
        }
    }

    protected boolean performDrop(DropTargetEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (selection instanceof IStructuredSelection) {
                return this.setInput(selection, event);
            }
            return false;
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            if (text != null && !text.isEmpty()) {
                return this.insertText(text);
            }
            return false;
        }
        return false;
    }

    protected boolean isValidInput(Object input, DropTargetEvent event) {
        for (RExprTypeUIAdapter uiAdapters : this.uiAdapters) {
            if (uiAdapters.isValidInput(input, this.getContext()) <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean setInput(Object input, DropTargetEvent event) {
        List<String> exprs;
        int selectedPriority = 0;
        RExprTypeUIAdapter selectedAdapter = null;
        for (RExprTypeUIAdapter uiAdapters : this.uiAdapters) {
            int priority = uiAdapters.isValidInput(input, this.getContext());
            if (priority <= 0 || !(uiAdapters.getType().getTypeKey() == this.getCurrentTypeKey() ? priority >= selectedPriority : priority > selectedPriority)) continue;
            selectedPriority = priority;
            selectedAdapter = uiAdapters;
        }
        if (selectedAdapter != null && (exprs = selectedAdapter.getInputExprs(input, this.getContext())) != null && exprs.size() == 1) {
            this.setExpr(selectedAdapter.getType().getTypeKey(), exprs.get(0), event.time);
            return true;
        }
        return false;
    }

    protected String getCurrentTypeKey() {
        return null;
    }

    protected IContext getContext() {
        return null;
    }

    protected boolean setExpr(String typeKey, String expr, int time) {
        return false;
    }

    protected boolean insertText(String text) {
        return false;
    }
}

