/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.internal.r.ui.search.RElementMatch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchQuery;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;
import org.eclipse.statet.ltk.core.IModelTypeDescriptor;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.util.ElementComparator;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.IEditorPart;

public class RElementSearchResult
extends ExtTextSearchResult<IRSourceUnit, RElementMatch>
implements IFileMatchAdapter,
IEditorMatchAdapter {
    public static final ElementMatchComparator<IRSourceUnit, RElementMatch> COMPARATOR = new ElementMatchComparator((Object[])new IRSourceUnit[0], (Comparator)new ElementComparator(RSymbolComparator.R_NAMES_COLLATOR), (Match[])new RElementMatch[0], (Comparator)new ExtTextSearchResult.DefaultMatchComparator());
    private final RElementSearchQuery query;

    private static ISourceUnit getSourceUnit(IEditorPart editor) {
        ISourceEditor sourceEditor = (ISourceEditor)editor.getAdapter(ISourceEditor.class);
        if (sourceEditor != null) {
            return sourceEditor.getSourceUnit();
        }
        return null;
    }

    public RElementSearchResult(RElementSearchQuery query) {
        super(COMPARATOR);
        this.query = query;
    }

    public ImageDescriptor getImageDescriptor() {
        return RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/obj/r_script");
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder(this.query.getSearchLabel());
        sb.append(" - ");
        int count = this.getMatchCount();
        sb.append(count);
        sb.append(' ');
        sb.append(this.query.getMatchLabel(count));
        sb.append(' ');
        sb.append("in");
        sb.append(' ');
        sb.append(this.query.getScopeLabel());
        return sb.toString();
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IFile getFile(Object element) {
        if (element instanceof ISourceElement) {
            element = ((ISourceElement)element).getSourceUnit();
        }
        if (element instanceof ISourceUnit) {
            element = ((ISourceUnit)element).getResource();
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        ISourceUnit su = LTK.getSourceUnitManager().getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)file, null, false, null);
        if (su != null) {
            try {
                IExtContentTypeManager typeManager = LTK.getExtContentTypeManager();
                IModelTypeDescriptor modelType = typeManager.getModelType(su.getModelTypeId());
                if (modelType != null && (modelType.getId() == "R" || modelType.getSecondaryTypeIds().contains("R"))) {
                    Match[] matchArray = this.getMatches(su);
                    return matchArray;
                }
            }
            finally {
                su.disconnect(null);
            }
        }
        return this.getComparator().getMatch0();
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        ISourceUnit su = RElementSearchResult.getSourceUnit(editor);
        while (su != null) {
            if (su.equals(match.getElement())) {
                return true;
            }
            su = su.getUnderlyingUnit();
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        ISourceUnit su = RElementSearchResult.getSourceUnit(editor);
        while (su != null) {
            Match[] matches = (RElementMatch[])this.getMatches(su);
            if (matches.length > 0) {
                return matches;
            }
            su = su.getUnderlyingUnit();
        }
        return this.getComparator().getMatch0();
    }
}

