/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public abstract class ResizeTableTextHandler
extends AbstractHandler {
    protected ResizeTableTextHandler() {
    }

    protected abstract int getDirection();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FontDescriptor fontDescriptor;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        FontRegistry fontRegistry = themeManager.getCurrentTheme().getFontRegistry();
        Font font = fontRegistry.get("org.eclipse.statet.workbench.themes.TableFont");
        if (font != null && (fontDescriptor = this.createFontDescriptor(font.getFontData())) != null) {
            fontRegistry.put("org.eclipse.statet.workbench.themes.TableFont", fontDescriptor.getFontData());
        }
        return null;
    }

    private FontDescriptor createFontDescriptor(FontData[] currentFontData) {
        int fontSize = currentFontData[0].getHeight();
        int n = fontSize = this.getDirection() > 0 ? Math.max(fontSize + 1, fontSize * 9 / 16 * 2) : Math.min(fontSize - 1, (fontSize + 2) * 8 / 18 * 2);
        if (fontSize <= 0) {
            return null;
        }
        return FontDescriptor.createFrom((FontData[])currentFontData).setHeight(fontSize);
    }

    public static class ZoomIn
    extends ResizeTableTextHandler {
        @Override
        protected int getDirection() {
            return 1;
        }
    }

    public static class ZoomOut
    extends ResizeTableTextHandler {
        @Override
        protected int getDirection() {
            return -1;
        }
    }
}

