/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataLabelProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.IFilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.IntervalVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.internal.r.ui.datafilterview.FilterClient;
import org.eclipse.statet.internal.r.ui.datafilterview.IntervalClient;
import org.eclipse.statet.internal.r.ui.datafilterview.LevelClient;
import org.eclipse.statet.internal.r.ui.datafilterview.ScrolledPageComposite;
import org.eclipse.statet.internal.r.ui.datafilterview.TextClient;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.services.IServiceLocator;

public class VariableContainer {
    private final IServiceLocator serviceLocator;
    private final ScrolledPageComposite variableComposite;
    private final List<VariableComposite> variables;
    private final RDataLabelProvider labelProvider;
    private final FilterSet filterSet;
    private RDataTableContentDescription description;

    public VariableContainer(IServiceLocator serviceLocator, ScrolledPageComposite variableComposite) {
        this.serviceLocator = serviceLocator;
        this.variableComposite = variableComposite;
        this.variables = new ArrayList<VariableComposite>();
        this.variableComposite.getContent().setLayout((Layout)LayoutUtils.newContentGrid((int)1));
        this.labelProvider = new RDataLabelProvider();
        this.filterSet = new FilterSet(Realm.getDefault()){

            @Override
            protected void filterRemoved(VariableFilter oldFilter) {
                int vIdx = VariableContainer.this.getVariable(oldFilter);
                if (vIdx >= 0) {
                    VariableComposite composite = (VariableComposite)((Object)VariableContainer.this.variables.remove(vIdx));
                    composite.dispose();
                }
            }

            @Override
            protected void filterReplaced(int idx, VariableFilter oldFilter, VariableFilter newFilter) {
                int vIdx = VariableContainer.this.getVariable(oldFilter);
                if (vIdx >= 0) {
                    VariableComposite composite = (VariableComposite)((Object)VariableContainer.this.variables.get(vIdx));
                    composite.setColumn(newFilter.getColumn());
                    FilterClient oldClient = composite.getClient();
                    VariableContainer.this.createFilterClient(composite, newFilter);
                    oldClient.dispose();
                    if (vIdx != idx) {
                        VariableContainer.this.variables.remove(vIdx);
                        VariableContainer.this.variables.add(idx, composite);
                    }
                    composite.layout(new Control[]{composite.getClient()});
                } else {
                    this.filterAdded(idx, newFilter);
                }
            }

            @Override
            protected void filterAdded(int idx, VariableFilter newFilter) {
                VariableComposite composite = VariableContainer.this.createVariable(newFilter.getColumn());
                VariableContainer.this.createFilterClient(composite, newFilter);
                VariableContainer.this.variables.add(idx, composite);
            }
        };
        this.filterSet.addPostListener(new IFilterListener(){

            @Override
            public void filterChanged() {
                for (VariableComposite variable : VariableContainer.this.variables) {
                    variable.updateImage(false);
                }
            }
        });
    }

    public void updateInput(RDataTableContentDescription description) {
        this.description = description;
        this.variableComposite.setRedraw(false);
        this.variableComposite.setDelayedReflow(true);
        try {
            this.filterSet.updateInput(description);
            if (this.variables.size() == 1) {
                this.variables.get(0).setExpanded(true);
            }
        }
        finally {
            this.variableComposite.setDelayedReflow(false);
            this.variableComposite.setRedraw(true);
            this.variableComposite.reflow(true);
        }
    }

    public RDataTableContentDescription getDescription() {
        return this.description;
    }

    protected FilterClient createFilterClient(VariableComposite composite, VariableFilter filter) {
        FilterClient client;
        if (filter == null) {
            return null;
        }
        switch (filter.getType().getId()) {
            case 0: {
                client = new LevelClient(composite, (LevelVariableFilter)filter);
                break;
            }
            case 1: {
                client = new IntervalClient(composite, (IntervalVariableFilter)filter);
                break;
            }
            case 2: {
                client = new TextClient(composite, (TextVariableFilter)filter);
                break;
            }
            default: {
                throw new IllegalStateException(filter.toString());
            }
        }
        this.variableComposite.adaptChild((Control)client);
        return client;
    }

    protected VariableComposite createVariable(RDataTableColumn column) {
        VariableComposite expandable = new VariableComposite(this.variableComposite.getContent(), this, column);
        expandable.setLayoutData(new GridData(4, 4, true, false));
        this.variableComposite.adaptChild((Control)expandable);
        return expandable;
    }

    public FilterSet getFilterSet() {
        return this.filterSet;
    }

    public IServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public ScrolledPageComposite getVariableComposite() {
        return this.variableComposite;
    }

    public List<VariableComposite> getVariables() {
        return this.variables;
    }

    protected int getVariable(VariableFilter filter) {
        int i = 0;
        while (i < this.variables.size()) {
            FilterClient client = this.variables.get(i).getClient();
            if (client != null && client.getFilter() == filter) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public RDataLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void dispose() {
        this.labelProvider.dispose();
    }
}

